/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.Set;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.MemberOfNode;
import oracle.toplink.essentials.internal.parsing.ParseTree;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SelectNode;
import oracle.toplink.essentials.internal.parsing.VariableNode;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class SelectGenerationContext
extends GenerationContext {
    private boolean useParallelExpressions = false;
    private boolean shouldCheckSelectNodeBeforeResolving = false;
    private boolean isNotIndicatedInMemberOf = false;
    private MemberOfNode memberOfNode = null;
    private boolean shouldUseOuterJoins = false;
    private GenerationContext outer = null;

    public SelectGenerationContext() {
    }

    public SelectGenerationContext(GenerationContext outer, ParseTree newParseTree) {
        this(outer.getParseTreeContext(), outer.getSession(), newParseTree);
        this.outer = outer;
    }

    public SelectGenerationContext(ParseTreeContext newContext, AbstractSession newSession, ParseTree newParseTree) {
        super(newContext, newSession, newParseTree);
        this.useParallelExpressions = this.computeUseParallelExpressions();
    }

    public void setMemberOfNode(MemberOfNode newMemberOfNode) {
        this.memberOfNode = newMemberOfNode;
    }

    public MemberOfNode getMemberOfNode() {
        return this.memberOfNode;
    }

    private boolean computeUseParallelExpressions() {
        boolean computedUseParallelExpressions = ((SelectNode)this.parseTree.getQueryNode()).hasOneToOneSelected(this);
        computedUseParallelExpressions = computedUseParallelExpressions || ((SelectNode)this.parseTree.getQueryNode()).isVariableInINClauseSelected(this) || this.parseTree.getContext().hasMoreThanOneVariablePerType() || this.parseTree.getContext().hasMoreThanOneAliasInFrom();
        return computedUseParallelExpressions;
    }

    public boolean useParallelExpressions() {
        return this.useParallelExpressions;
    }

    public void checkSelectNodeBeforeResolving(boolean shouldCheck) {
        this.shouldCheckSelectNodeBeforeResolving = shouldCheck;
    }

    public boolean shouldCheckSelectNodeBeforeResolving() {
        return this.shouldCheckSelectNodeBeforeResolving;
    }

    public boolean shouldUseOuterJoins() {
        return this.shouldUseOuterJoins;
    }

    public void useOuterJoins() {
        this.shouldUseOuterJoins = true;
    }

    public void dontUseOuterJoins() {
        this.shouldUseOuterJoins = false;
    }

    public boolean hasMemberOfNode() {
        return this.memberOfNode != null;
    }

    public GenerationContext getOuterContext() {
        return this.outer;
    }

    public Expression joinVariables(Set variables) {
        if (this.outer == null || variables == null || variables.isEmpty()) {
            return null;
        }
        Expression expr = null;
        for (String name : variables) {
            VariableNode var = new VariableNode(name);
            Expression innerExpr = var.generateExpression(this);
            Expression outerExpr = var.generateExpression(this.outer);
            Expression join = innerExpr.equal(outerExpr);
            expr = var.appendExpression(expr, join);
        }
        return expr;
    }
}

