/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.descriptors.ObjectBuilder;
import oracle.toplink.essentials.internal.expressions.ForUpdateOfClause;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.QueryKeyExpression;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.queryframework.ObjectBuildingQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;

public class JoinedAttributeManager
implements Cloneable {
    protected ArrayList joinedAttributeExpressions_;
    protected ArrayList joinedMappingExpressions_;
    protected ArrayList joinedAttributes_;
    protected boolean isToManyJoin = false;
    protected boolean hasOuterJoinedAttribute = true;
    protected transient HashMap joinedMappingIndexes_;
    protected transient HashMap joinedMappingQueries_;
    protected List dataResults;
    protected ClassDescriptor descriptor;
    protected ExpressionBuilder baseExpressionBuilder;
    protected ObjectBuildingQuery baseQuery;
    protected int parentResultIndex;

    public JoinedAttributeManager() {
    }

    public JoinedAttributeManager(ClassDescriptor descriptor, ExpressionBuilder baseBuilder, ObjectBuildingQuery baseQuery) {
        this.descriptor = descriptor;
        this.baseQuery = baseQuery;
        this.baseExpressionBuilder = baseBuilder;
        this.parentResultIndex = 0;
    }

    public void addJoinedAttribute(String attributeExpression) {
        this.getJoinedAttributes().add(attributeExpression);
    }

    public void addJoinedAttributeExpression(Expression attributeExpression) {
        this.getJoinedAttributeExpressions().add(attributeExpression);
    }

    public void addJoinedMappingExpression(Expression mappingExpression) {
        this.getJoinedMappingExpressions().add(mappingExpression);
    }

    public void addJoinedMapping(String attributeName) {
        this.addJoinedMappingExpression(this.baseExpressionBuilder.get(attributeName));
    }

    public Object clone() {
        JoinedAttributeManager joinManager = new JoinedAttributeManager();
        joinManager.baseExpressionBuilder = this.baseExpressionBuilder;
        joinManager.baseQuery = this.baseQuery;
        joinManager.descriptor = this.descriptor;
        if (this.joinedAttributeExpressions_ != null) {
            joinManager.joinedAttributeExpressions_ = (ArrayList)this.joinedAttributeExpressions_.clone();
        }
        if (this.joinedMappingExpressions_ != null) {
            joinManager.joinedMappingExpressions_ = (ArrayList)this.joinedMappingExpressions_.clone();
        }
        if (this.joinedAttributes_ != null) {
            joinManager.joinedAttributes_ = (ArrayList)this.joinedAttributes_.clone();
        }
        if (this.joinedMappingIndexes_ != null) {
            joinManager.joinedMappingIndexes_ = (HashMap)this.joinedMappingIndexes_.clone();
        }
        if (this.joinedMappingQueries_ != null) {
            joinManager.joinedMappingQueries_ = (HashMap)this.joinedMappingQueries_.clone();
        }
        joinManager.isToManyJoin = this.isToManyJoin;
        joinManager.hasOuterJoinedAttribute = this.hasOuterJoinedAttribute;
        return joinManager;
    }

    public int computeJoiningMappingIndexes(boolean includeAllSubclassFields, AbstractSession session, int offset) {
        if (!this.hasJoinedExpressions()) {
            return offset;
        }
        this.setJoinedMappingIndexes_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
        int fieldIndex = 0;
        fieldIndex = includeAllSubclassFields ? this.getDescriptor().getAllFields().size() : this.getDescriptor().getFields().size();
        fieldIndex += offset;
        fieldIndex = this.computeIndexesForJoinedExpressions(this.getJoinedAttributeExpressions(), fieldIndex, session);
        fieldIndex = this.computeIndexesForJoinedExpressions(this.getJoinedMappingExpressions(), fieldIndex, session);
        return fieldIndex;
    }

    protected void computeNestedQueriesForJoinedExpressions(List joinedExpressions, AbstractSession session, ObjectLevelReadQuery readQuery) {
        for (int index = 0; index < joinedExpressions.size(); ++index) {
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            objectExpression.getBuilder().setSession(session.getRootSession(null));
            if (objectExpression.getBuilder().getQueryClass() == null) {
                objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            ObjectExpression baseExpression = objectExpression;
            while (!baseExpression.getBaseExpression().isExpressionBuilder()) {
                baseExpression = (ObjectExpression)((QueryKeyExpression)baseExpression).getBaseExpression();
            }
            this.addJoinedAttribute(baseExpression.getName());
            if (objectExpression.getBaseExpression() != objectExpression.getBuilder() || !objectExpression.getMapping().isForeignReferenceMapping()) continue;
            ForeignReferenceMapping mapping = (ForeignReferenceMapping)objectExpression.getMapping();
            ObjectLevelReadQuery nestedQuery = mapping.prepareNestedJoins(this, session);
            this.getJoinedMappingQueries_().put(mapping, nestedQuery);
        }
    }

    public void computeJoiningMappingQueries(AbstractSession session) {
        if (this.hasJoinedExpressions()) {
            this.joinedAttributes_ = new ArrayList(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            this.setJoinedMappingQueries_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedAttributeExpressions(), session, (ObjectLevelReadQuery)this.baseQuery);
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedMappingExpressions(), session, (ObjectLevelReadQuery)this.baseQuery);
        }
    }

    protected int computeIndexesForJoinedExpressions(List joinedExpressions, int currentIndex, AbstractSession session) {
        for (int index = 0; index < joinedExpressions.size(); ++index) {
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            if (objectExpression.getBaseExpression() == objectExpression.getBuilder() && objectExpression.getMapping() != null && objectExpression.getMapping().isForeignReferenceMapping()) {
                this.getJoinedMappingIndexes_().put(objectExpression.getMapping(), new Integer(currentIndex));
            }
            ClassDescriptor descriptor = objectExpression.getMapping().getReferenceDescriptor();
            int nFields = objectExpression.isQueryKeyExpression() && ((QueryKeyExpression)objectExpression).isUsingOuterJoinForMultitableInheritance() ? descriptor.getAllFields().size() : descriptor.getFields().size();
            currentIndex += nFields;
        }
        return currentIndex;
    }

    public ExpressionBuilder getBaseExpressionBuilder() {
        return this.baseExpressionBuilder;
    }

    public ObjectBuildingQuery getBaseQuery() {
        return this.baseQuery;
    }

    public List getDataResults_() {
        return this.dataResults;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List getJoinedAttributes() {
        if (this.joinedAttributes_ == null) {
            this.joinedAttributes_ = new ArrayList();
        }
        return this.joinedAttributes_;
    }

    public List getJoinedAttributeExpressions() {
        if (this.joinedAttributeExpressions_ == null) {
            this.joinedAttributeExpressions_ = new ArrayList();
        }
        return this.joinedAttributeExpressions_;
    }

    public List getJoinedMappingExpressions() {
        if (this.joinedMappingExpressions_ == null) {
            this.joinedMappingExpressions_ = new ArrayList();
        }
        return this.joinedMappingExpressions_;
    }

    public boolean hasJoinedAttributeExpressions() {
        return this.joinedAttributeExpressions_ != null && !this.joinedAttributeExpressions_.isEmpty();
    }

    public boolean hasJoinedExpressions() {
        return this.hasJoinedAttributeExpressions() || this.hasJoinedMappingExpressions();
    }

    public boolean hasJoinedMappingExpressions() {
        return this.joinedMappingExpressions_ != null && !this.joinedMappingExpressions_.isEmpty();
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes_ != null && !this.joinedAttributes_.isEmpty();
    }

    public boolean hasOuterJoinedAttributeQuery() {
        return this.hasOuterJoinedAttribute;
    }

    public boolean isToManyJoin() {
        return this.isToManyJoin;
    }

    public boolean isAttributeJoined(ClassDescriptor mappingDescriptor, String attributeName) {
        if (mappingDescriptor.isAggregateDescriptor() && mappingDescriptor != this.getDescriptor()) {
            return false;
        }
        if (this.hasJoinedAttributes()) {
            return this.joinedAttributes_.contains(attributeName);
        }
        return this.isAttributeExpressionJoined(attributeName) || this.isAttributeMappingJoined(attributeName);
    }

    protected boolean isAttributeNameInJoinedExpressionList(String attributeName, List joinedExpressionList) {
        for (QueryKeyExpression expression : joinedExpressionList) {
            while (!expression.getBaseExpression().isExpressionBuilder()) {
                expression = (QueryKeyExpression)expression.getBaseExpression();
            }
            if (!expression.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributeExpressionJoined(String attributeName) {
        return this.isAttributeNameInJoinedExpressionList(attributeName, this.getJoinedAttributeExpressions());
    }

    protected boolean isAttributeMappingJoined(String attributeName) {
        return this.isAttributeNameInJoinedExpressionList(attributeName, this.getJoinedMappingExpressions());
    }

    public void setJoinedAttributeExpressions_(List joinedExpressions) {
        this.joinedAttributeExpressions_ = new ArrayList(joinedExpressions);
    }

    public void setJoinedMappingExpressions_(List joinedMappingExpressions) {
        this.joinedMappingExpressions_ = new ArrayList(joinedMappingExpressions);
    }

    public Map getJoinedMappingIndexes_() {
        return this.joinedMappingIndexes_;
    }

    public Map getJoinedMappingQueries_() {
        return this.joinedMappingQueries_;
    }

    protected void setJoinedMappingQueries_(HashMap joinedMappingQueries) {
        this.joinedMappingQueries_ = joinedMappingQueries;
    }

    public void setJoinedMappingIndexes_(HashMap joinedMappingIndexes) {
        this.joinedMappingIndexes_ = joinedMappingIndexes;
    }

    protected void setIsOuterJoinedAttributeQuery(boolean isOuterJoinedAttribute) {
        this.hasOuterJoinedAttribute = isOuterJoinedAttribute;
    }

    protected void setIsToManyJoinQuery(boolean isToManyJoin) {
        this.isToManyJoin = isToManyJoin;
    }

    public void prepareJoinExpressions(AbstractSession session) {
        Expression expression;
        int index;
        this.setIsOuterJoinedAttributeQuery(false);
        for (index = 0; index < this.getJoinedAttributeExpressions().size(); ++index) {
            expression = (Expression)this.getJoinedAttributeExpressions().get(index);
            if (expression.isObjectExpression()) {
                ((ObjectExpression)expression).setShouldUseOuterJoinForMultitableInheritance(true);
            }
            this.prepareJoinExpression(expression, session);
        }
        for (index = 0; index < this.getJoinedMappingExpressions().size(); ++index) {
            expression = (Expression)this.getJoinedMappingExpressions().get(index);
            if (expression.isObjectExpression()) {
                ((ObjectExpression)expression).setShouldUseOuterJoinForMultitableInheritance(true);
            }
            this.prepareJoinExpression(expression, session);
        }
        this.computeJoiningMappingQueries(session);
    }

    protected void prepareJoinExpression(Expression expression, AbstractSession session) {
        if (!expression.isQueryKeyExpression()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(expression);
        }
        QueryKeyExpression objectExpression = (QueryKeyExpression)expression;
        objectExpression.getBuilder().setSession(session.getRootSession(null));
        if (objectExpression.getBuilder().getQueryClass() == null) {
            objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
        }
        if (objectExpression.getMapping() == null || !objectExpression.getMapping().isJoiningSupported()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(objectExpression);
        }
        ObjectExpression baseExpression = objectExpression;
        while (!baseExpression.isExpressionBuilder()) {
            if (baseExpression.shouldQueryToManyRelationship()) {
                this.setIsToManyJoinQuery(true);
            }
            if (baseExpression.shouldUseOuterJoin()) {
                this.setIsOuterJoinedAttributeQuery(true);
            }
            baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
        }
    }

    public void processJoinedMappings() {
        block4: {
            ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
            if (!objectBuilder.hasJoinedAttributes()) break block4;
            Vector<String> mappingJoinedAttributes = objectBuilder.getJoinedAttributes();
            if (!this.hasJoinedExpressions()) {
                for (int i = 0; i < mappingJoinedAttributes.size(); ++i) {
                    this.addJoinedMapping(mappingJoinedAttributes.get(i));
                }
            } else {
                for (int i = 0; i < mappingJoinedAttributes.size(); ++i) {
                    String attribute = mappingJoinedAttributes.get(i);
                    if (this.isAttributeExpressionJoined(attribute)) continue;
                    this.addJoinedMapping(attribute);
                }
            }
        }
    }

    public void reset() {
        this.joinedMappingExpressions_ = null;
        this.joinedAttributes_ = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = true;
        this.joinedMappingIndexes_ = null;
        this.joinedMappingQueries_ = null;
        this.dataResults = null;
    }

    public void setBaseQuery(ObjectLevelReadQuery query) {
        this.baseQuery = query;
    }

    protected void setBaseExpressionBuilder(ExpressionBuilder builder) {
        this.baseExpressionBuilder = builder;
    }

    public void setDataResults(List dataResults, AbstractSession session) {
        this.dataResults = dataResults;
        if (this.getJoinedMappingQueries_() != null && !this.getJoinedMappingQueries_().isEmpty() && dataResults != null && !dataResults.isEmpty()) {
            for (Map.Entry entry : this.getJoinedMappingQueries_().entrySet()) {
                ObjectLevelReadQuery nestedQuery = (ObjectLevelReadQuery)entry.getValue();
                if (!nestedQuery.getJoinedAttributeManager().isToManyJoin()) continue;
                ForeignReferenceMapping frMapping = (ForeignReferenceMapping)entry.getKey();
                Object indexObject = this.getJoinedMappingIndexes_().get(entry.getKey());
                ArrayList<AbstractRecord> nestedDataResults = new ArrayList<AbstractRecord>(dataResults.size());
                for (int i = 0; i < dataResults.size(); ++i) {
                    AbstractRecord row = (AbstractRecord)dataResults.get(i);
                    nestedDataResults.add(frMapping.trimRowForJoin(row, indexObject, session));
                }
                nestedQuery.getJoinedAttributeManager().setDataResults(nestedDataResults, session);
            }
        }
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ForUpdateOfClause setupLockingClauseForJoinedExpressions(ForUpdateOfClause lockingClause, AbstractSession session) {
        if (this.hasJoinedAttributeExpressions()) {
            this.setupLockingClauseForJoinedExpressions(this.getJoinedAttributeExpressions(), session);
        }
        if (this.hasJoinedMappingExpressions()) {
            this.setupLockingClauseForJoinedExpressions(this.getJoinedMappingExpressions(), session);
        }
        return lockingClause;
    }

    private void setupLockingClauseForJoinedExpressions(List joinedExpressions, AbstractSession session) {
        for (Expression expression : joinedExpressions) {
            Object nestedDescriptor;
            if (!expression.isObjectExpression()) continue;
            ObjectExpression joinedAttribute = (ObjectExpression)expression;
            joinedAttribute.getBuilder().setSession(session.getRootSession(null));
            if (joinedAttribute.getBuilder().getQueryClass() == null) {
                joinedAttribute.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            if ((nestedDescriptor = null) != null) continue;
            return;
        }
    }

    public void setParentResultIndex(int parentsResultIndex) {
        this.parentResultIndex = parentsResultIndex;
    }

    public int getParentResultIndex() {
        return this.parentResultIndex;
    }
}

