/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ConstantExpression;
import oracle.toplink.essentials.internal.parsing.AttributeNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.LogicalOperatorNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.internal.parsing.VariableNode;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class DotNode
extends LogicalOperatorNode {
    private Object enumConstant;

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(context));
            reportQuery.dontRetrievePrimaryKeys();
        }
    }

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.getLeft() != null) {
            this.setLeft(this.getLeft().qualifyAttributeAccess(context));
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        String name = ((AttributeNode)this.right).getAttributeName();
        Node leftMost = this.getLeftMostNode();
        if (this.isDeclaredVariable(leftMost, context)) {
            this.left.validate(context);
            this.checkNavigation(this.left, context);
            Object type = typeHelper.resolveAttribute(this.left.getType(), name);
            if (type == null) {
                throw EJBQLException.unknownAttribute(context.getQueryInfo(), this.right.getLine(), this.right.getColumn(), name, typeHelper.getTypeName(this.left.getType()));
            }
            this.setType(type);
            this.right.setType(type);
        } else {
            String typeName = this.left.getAsString();
            Object type = this.resolveEnumTypeName(typeName, typeHelper);
            if (type != null && typeHelper.isEnumType(type)) {
                this.enumConstant = typeHelper.resolveEnumConstant(type, name);
                if (this.enumConstant == null) {
                    throw EJBQLException.invalidEnumLiteral(context.getQueryInfo(), this.right.getLine(), this.right.getColumn(), typeName, name);
                }
            } else {
                throw EJBQLException.aliasResolutionException(context.getQueryInfo(), leftMost.getLine(), leftMost.getColumn(), leftMost.getAsString());
            }
            this.setType(type);
            this.right.setType(type);
        }
    }

    private void checkNavigation(Node node, ParseTreeContext context) {
        Object type;
        TypeHelper typeHelper = context.getTypeHelper();
        if (!(typeHelper.isEntityClass(type = node.getType()) || typeHelper.isEmbeddable(type) || typeHelper.isEnumType(type))) {
            throw EJBQLException.invalidNavigation(context.getQueryInfo(), node.getLine(), node.getColumn(), this.getAsString(), node.getAsString(), typeHelper.getTypeName(type));
        }
        if (node.isDotNode()) {
            Node left = node.getLeft();
            AttributeNode right = (AttributeNode)node.getRight();
            if (typeHelper.isCollectionValuedRelationship(left.getType(), right.getAttributeName())) {
                throw EJBQLException.invalidCollectionNavigation(context.getQueryInfo(), right.getLine(), right.getColumn(), this.getAsString(), right.getAttributeName());
            }
        }
    }

    private boolean isDeclaredVariable(Node node, ParseTreeContext context) {
        if (node.isVariableNode()) {
            String name = ((VariableNode)node).getCanonicalVariableName();
            return context.isVariable(name);
        }
        return false;
    }

    public Expression generateExpression(GenerationContext context) {
        Node left = this.getLeft();
        Node right = this.getRight();
        if (this.enumConstant != null) {
            return new ConstantExpression(this.enumConstant, new ExpressionBuilder());
        }
        Expression whereClause = left.generateExpression(context);
        if (right.isAttributeNode()) {
            ((AttributeNode)right).setMapping(this.resolveMapping(context));
        }
        whereClause = right.addToExpression(whereClause, context);
        return whereClause;
    }

    public boolean isDotNode() {
        return true;
    }

    public boolean endsWithDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    public Class getTypeOfDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)mapping).getAttributeClassification();
        }
        return null;
    }

    public boolean endsWithCollectionField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isCollectionMapping();
    }

    public String resolveAttribute() {
        return ((AttributeNode)this.getRight()).getAttributeName();
    }

    public DatabaseMapping resolveMapping(GenerationContext context) {
        Class leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveMapping(context, leftClass);
    }

    public Class resolveClass(GenerationContext context) {
        Class leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveClass(context, leftClass);
    }

    public String getAsString() {
        return this.left.getAsString() + "." + this.right.getAsString();
    }

    private Node getLeftMostNode() {
        return this.left.isDotNode() ? ((DotNode)this.left).getLeftMostNode() : this.left;
    }

    private Object resolveEnumTypeName(String name, TypeHelper helper) {
        int index;
        Object type = helper.resolveTypeName(name);
        if (type == null && (index = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, index) + '$' + name.substring(index + 1);
            type = helper.resolveTypeName(name);
        }
        return type;
    }
}

