/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.indirection;

import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.indirection.DatabaseValueHolder;
import oracle.toplink.essentials.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;

public class QueryBasedValueHolder
extends DatabaseValueHolder {
    protected transient ReadQuery query;

    public QueryBasedValueHolder(ReadQuery query, AbstractRecord row, AbstractSession session) {
        this.row = row;
        this.session = session;
        if (!session.isUnitOfWork()) {
            this.session = session.getRootSession(query);
        }
        this.query = query;
    }

    protected ReadQuery getQuery() {
        return this.query;
    }

    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.getSession());
    }

    protected Object instantiate(AbstractSession session) throws DatabaseException {
        if (session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        return session.executeQuery((DatabaseQuery)this.getQuery(), this.getRow());
    }

    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    public void releaseWrappedValueHolder() {
        AbstractSession session = this.getSession();
        if (session != null && session.isUnitOfWork()) {
            this.setSession(session.getRootSession(this.query));
        }
    }

    protected void resetFields() {
        super.resetFields();
        this.setQuery(null);
    }

    protected void setQuery(ReadQuery theQuery) {
        this.query = theQuery;
    }

    public boolean isPessimisticLockingValueHolder() {
        if (this.getQuery() == null || !this.getQuery().isObjectLevelReadQuery()) {
            return false;
        }
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.getQuery();
        return query.isLockQuery(this.getSession());
    }
}

