/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.databaseaccess;

import java.sql.Connection;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.sessions.Login;

public abstract class DatasourceAccessor
implements Accessor {
    protected Object datasourceConnection;
    protected Login login;
    protected int callCount = 0;
    protected boolean isInTransaction = false;
    protected boolean isConnected = false;
    protected DatasourcePlatform platform;

    public Object clone() {
        try {
            DatasourceAccessor accessor = (DatasourceAccessor)super.clone();
            return accessor;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError("clone not supported");
        }
    }

    public void afterJTSTransaction() {
        if (this.usesExternalTransactionController()) {
            this.setIsInTransaction(false);
            if (this.getDatasourceConnection() != null && this.usesExternalConnectionPooling()) {
                this.closeConnection();
                this.setDatasourceConnection(null);
            }
        }
    }

    protected void setIsInTransaction(boolean value) {
        this.isInTransaction = value;
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public boolean usesExternalConnectionPooling() {
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            this.setIsInTransaction(true);
            return;
        }
        session.log(2, "transaction", "begin_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.incrementCallCount(session);
            this.basicBeginTransaction(session);
            this.setIsInTransaction(true);
        }
        finally {
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    protected abstract void basicBeginTransaction(AbstractSession var1);

    protected abstract void basicCommitTransaction(AbstractSession var1);

    protected abstract void basicRollbackTransaction(AbstractSession var1);

    public synchronized void decrementCallCount() {
        this.setCallCount(this.getCallCount() - 1);
        if (this.usesExternalConnectionPooling() && !this.isInTransaction() && this.getCallCount() == 0) {
            try {
                this.closeConnection();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public synchronized void incrementCallCount(AbstractSession session) {
        this.setCallCount(this.getCallCount() + 1);
        if (this.getCallCount() == 1) {
            if (this.getLogin() == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.getDatasourceConnection() != null) {
                if (!this.isConnected()) {
                    if (this.isInTransaction()) {
                        throw DatabaseException.databaseAccessorNotConnected();
                    }
                    this.reconnect(session);
                }
            } else if (this.usesExternalConnectionPooling()) {
                this.reconnect(session);
            } else {
                throw DatabaseException.databaseAccessorNotConnected();
            }
        }
    }

    protected void connect(Login login) throws DatabaseException {
        this.setDatasourceConnection(login.connectToDatasource(this));
        this.setIsConnected(true);
    }

    protected void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    protected void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (session.getExternalTransactionController() == null) {
                this.setIsInTransaction(false);
                if (this.getDatasourceConnection() != null && this.usesExternalConnectionPooling()) {
                    this.closeConnection();
                    this.setDatasourceConnection(null);
                }
            }
            return;
        }
        session.log(2, "transaction", "commit_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.incrementCallCount(session);
            this.basicCommitTransaction(session);
            session.afterTransaction(true, false);
            this.setIsInTransaction(false);
        }
        finally {
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Login login, AbstractSession session) throws DatabaseException {
        session.startOperationProfile("connect");
        session.incrementProfile("ConnectCalls");
        try {
            if (session.shouldLog(4, "connection")) {
                session.log(4, "connection", "connecting", new Object[]{login}, this);
            }
            this.setLogin(login);
            this.setDatasourcePlatform((DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform());
            try {
                this.connect(login);
                this.setIsInTransaction(false);
            }
            catch (RuntimeException exception) {
                session.handleSevere(exception);
            }
            session.getEventManager().postConnect(this);
            this.incrementCallCount(session);
            try {
                this.buildConnectLog(session);
            }
            finally {
                this.decrementCallCount();
            }
        }
        finally {
            session.endOperationProfile("connect");
        }
    }

    protected abstract void closeDatasourceConnection();

    protected abstract Object basicExecuteCall(Call var1, AbstractRecord var2, AbstractSession var3);

    protected abstract void buildConnectLog(AbstractSession var1);

    public Login getLogin() {
        return this.login;
    }

    protected void setLogin(Login login) {
        this.login = login;
    }

    public void disconnect(AbstractSession session) throws DatabaseException {
        session.log(4, "connection", "disconnect", (Object[])null, this);
        if (this.getDatasourceConnection() == null) {
            return;
        }
        session.incrementProfile("DisconnectCalls");
        session.startOperationProfile("connect");
        this.closeDatasourceConnection();
        this.setDatasourceConnection(null);
        this.setIsInTransaction(false);
        session.endOperationProfile("connect");
    }

    public void closeConnection() {
        try {
            if (this.getDatasourceConnection() != null) {
                if (this.isDatasourceConnected()) {
                    this.closeDatasourceConnection();
                }
                this.setDatasourceConnection(null);
            }
        }
        catch (DatabaseException exception) {
            this.setDatasourceConnection(null);
        }
    }

    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (session.shouldLog(3, "sql")) {
            session.log(3, "sql", call.getLogString(this), null, this, false);
        }
        Object result = this.basicExecuteCall(call, translationRow, session);
        return result;
    }

    public void reestablishConnection(AbstractSession session) throws DatabaseException {
        if (session.shouldLog(4, "connection")) {
            Object[] args = new Object[]{this.getLogin()};
            session.log(4, "connection", "reconnecting", args, this);
        }
        this.reconnect(session);
        this.setIsInTransaction(false);
        session.getEventManager().postConnect(this);
    }

    protected void reconnect(AbstractSession session) throws DatabaseException {
        session.log(1, "connection", "reconnecting_to_external_connection_pool");
        session.startOperationProfile("connect");
        this.connect(this.getLogin());
        session.endOperationProfile("connect");
    }

    public DatasourcePlatform getDatasourcePlatform() {
        return this.platform;
    }

    public void setDatasourcePlatform(DatasourcePlatform platform) {
        this.platform = platform;
    }

    public Object getDatasourceConnection() {
        return this.datasourceConnection;
    }

    public Connection getConnection() {
        return (Connection)this.getDatasourceConnection();
    }

    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName, AbstractSession session) throws DatabaseException {
        return new Vector();
    }

    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types, AbstractSession session) throws DatabaseException {
        return new Vector();
    }

    protected void setDatasourceConnection(Object connection) {
        this.datasourceConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (session.getExternalTransactionController() == null) {
                this.setIsInTransaction(false);
                if (this.getDatasourceConnection() != null && this.usesExternalConnectionPooling()) {
                    this.closeConnection();
                    this.setDatasourceConnection(null);
                }
            }
            return;
        }
        session.log(2, "transaction", "rollback_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.incrementCallCount(session);
            this.basicRollbackTransaction(session);
        }
        finally {
            session.afterTransaction(false, false);
            this.setIsInTransaction(false);
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    public boolean usesExternalTransactionController() {
        if (this.getLogin() == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.getLogin().shouldUseExternalTransactionController();
    }

    public boolean isConnected() {
        if (this.getDatasourceConnection() == null && this.getLogin() == null) {
            return false;
        }
        if (this.usesExternalConnectionPooling()) {
            return true;
        }
        if (this.getDatasourceConnection() == null) {
            return false;
        }
        return this.isDatasourceConnected();
    }

    protected abstract boolean isDatasourceConnected();

    public void flushSelectCalls(AbstractSession session) {
    }

    public void writesCompleted(AbstractSession session) {
    }
}

