/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.threetier;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.threetier.ServerSession;

public class ConnectionPool {
    protected boolean isConnected;
    protected int maxNumberOfConnections;
    protected int minNumberOfConnections;
    protected Vector connectionsAvailable;
    protected Vector connectionsUsed;
    protected Login login;
    protected String name;
    protected ServerSession owner;

    public ConnectionPool() {
        this.maxNumberOfConnections = 50;
        this.minNumberOfConnections = 3;
        this.resetConnections();
    }

    public ConnectionPool(String name, Login login, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        this.login = login;
        this.owner = owner;
        this.name = name;
        this.maxNumberOfConnections = maxNumberOfConnections;
        this.minNumberOfConnections = minNumberOfConnections;
        this.resetConnections();
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        while (!this.hasConnectionAvailable()) {
            if (this.getTotalNumberOfConnections() < this.getMaxNumberOfConnections()) {
                Accessor connection = this.buildConnection();
                this.getConnectionsUsed().addElement(connection);
                return connection;
            }
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitFailureOnClientSession(exception);
            }
        }
        Accessor connection = (Accessor)this.getConnectionsAvailable().firstElement();
        this.getConnectionsAvailable().removeElement(connection);
        this.getConnectionsUsed().addElement(connection);
        this.getOwner().updateProfile(this.getName(), new Integer(this.getConnectionsUsed().size()));
        return connection;
    }

    protected Accessor buildConnection() {
        Login localLogin = (Login)this.getLogin().clone();
        Accessor connection = localLogin.buildAccessor();
        connection.connect(localLogin, this.getOwner());
        return connection;
    }

    public Vector getConnectionsAvailable() {
        return this.connectionsAvailable;
    }

    protected Vector getConnectionsUsed() {
        return this.connectionsUsed;
    }

    public Login getLogin() {
        return this.login;
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMinNumberOfConnections() {
        return this.minNumberOfConnections;
    }

    public String getName() {
        return this.name;
    }

    protected ServerSession getOwner() {
        return this.owner;
    }

    public int getTotalNumberOfConnections() {
        return this.getConnectionsUsed().size() + this.getConnectionsAvailable().size();
    }

    public boolean hasConnectionAvailable() {
        return !this.getConnectionsAvailable().isEmpty();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        this.getConnectionsUsed().removeElement(connection);
        if (this.getTotalNumberOfConnections() < this.getMinNumberOfConnections()) {
            this.getConnectionsAvailable().addElement(connection);
        } else {
            connection.disconnect(this.getOwner());
        }
        this.notify();
    }

    public void resetConnections() {
        this.connectionsUsed = new Vector();
        this.connectionsAvailable = new Vector();
    }

    protected void setConnectionsAvailable(Vector connectionsAvailable) {
        this.connectionsAvailable = connectionsAvailable;
    }

    protected void setConnectionsUsed(Vector connectionsUsed) {
        this.connectionsUsed = connectionsUsed;
    }

    public void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public void setMaxNumberOfConnections(int maxNumberOfConnections) {
        this.maxNumberOfConnections = maxNumberOfConnections;
    }

    public void setMinNumberOfConnections(int minNumberOfConnections) {
        this.minNumberOfConnections = minNumberOfConnections;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setOwner(ServerSession owner) {
        this.owner = owner;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
        Enumeration avaiableEnum = this.getConnectionsAvailable().elements();
        while (avaiableEnum.hasMoreElements()) {
            try {
                ((Accessor)avaiableEnum.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException exception) {}
        }
        Enumeration usedEnum = this.getConnectionsUsed().elements();
        while (usedEnum.hasMoreElements()) {
            try {
                ((Accessor)usedEnum.nextElement()).disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        this.resetConnections();
    }

    public synchronized void startUp() {
        for (int index = this.getMinNumberOfConnections(); index > 0; --index) {
            this.getConnectionsAvailable().addElement(this.buildConnection());
        }
        this.setIsConnected(true);
    }

    public String toString() {
        Object[] args = new Object[]{new Integer(this.getMinNumberOfConnections()), new Integer(this.getMaxNumberOfConnections())};
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("min_max", args);
    }
}

