/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.expressions.DataExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionNormalizer;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;

public class TableExpression
extends DataExpression {
    protected DatabaseTable table;

    public TableExpression() {
    }

    public TableExpression(DatabaseTable aTable) {
        this.table = aTable;
    }

    public String descriptionOfNodeType() {
        return "Table";
    }

    public Expression getField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        if (!field.hasTableName()) {
            field.setTable(this.getTable());
        }
        return this.getField(field);
    }

    public Vector getOwnedTables() {
        Vector<DatabaseTable> result = new Vector<DatabaseTable>(1);
        result.addElement(this.getTable());
        return result;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public boolean isTableExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.getTable().getTableQualifier().length() == 0 && normalizer.getSession().getDatasourceLogin().getTableQualifier().length() != 0) {
            this.getTable().setTableQualifier(normalizer.getSession().getDatasourceLogin().getTableQualifier());
        }
        return super.normalize(normalizer);
    }

    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getTable(this.getTable());
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context);
        return twistedBase.getTable(this.getTable());
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getTable().toString());
        writer.write(this.tableAliasesDescription());
    }
}

