/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.expressions.ParameterExpression;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.DatasourceCallQueryMechanism;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;

public abstract class DatasourceCall
implements Call {
    protected DatabaseQuery query;
    protected transient Vector parameters;
    protected transient Vector parameterTypes;
    public static final Integer LITERAL = new Integer(1);
    public static final Integer MODIFY = new Integer(2);
    public static final Integer TRANSLATION = new Integer(3);
    public static final Integer CUSTOM_MODIFY = new Integer(4);
    public static final Integer OUT = new Integer(5);
    public static final Integer INOUT = new Integer(6);
    public static final Integer IN = new Integer(7);
    public static final Integer OUT_CURSOR = new Integer(8);
    protected boolean isPrepared = false;
    protected int returnType = 3;
    protected static final int NO_RETURN = 1;
    protected static final int RETURN_ONE_ROW = 2;
    protected static final int RETURN_MANY_ROWS = 3;
    protected static final int RETURN_CURSOR = 4;

    public Vector getParameters() {
        if (this.parameters == null) {
            this.parameters = NonSynchronizedVector.newInstance();
        }
        return this.parameters;
    }

    public Vector getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = NonSynchronizedVector.newInstance();
        }
        return this.parameterTypes;
    }

    public void setParameters(Vector parameters) {
        this.parameters = parameters;
    }

    public void setParameterTypes(Vector parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.getParameters().isEmpty();
    }

    public boolean areManyRowsReturned() {
        return this.getReturnType() == 3;
    }

    public boolean isOutputParameterType(Integer parameterType) {
        return parameterType == OUT || parameterType == INOUT || parameterType == OUT_CURSOR;
    }

    protected boolean isPrepared() {
        return this.isPrepared;
    }

    protected void setIsPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new DatasourceCallQueryMechanism(query, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism callMechanism = (DatasourceCallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract String getLogString(Accessor var1);

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public boolean isCursorReturned() {
        return this.getReturnType() == 4;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNothingReturned() {
        return this.getReturnType() == 1;
    }

    public boolean isOneRowReturned() {
        return this.getReturnType() == 2;
    }

    public boolean isSQLCall() {
        return false;
    }

    public boolean isStoredFunctionCall() {
        return false;
    }

    public boolean isStoredProcedureCall() {
        return false;
    }

    public boolean isEJBQLCall() {
        return false;
    }

    public boolean isEISInteraction() {
        return false;
    }

    public boolean isQueryStringCall() {
        return false;
    }

    public void prepare(AbstractSession session) {
        this.setIsPrepared(true);
    }

    public void returnCursor() {
        this.setReturnType(4);
    }

    public void returnManyRows() {
        this.setReturnType(3);
    }

    public void returnNothing() {
        this.setReturnType(1);
    }

    public void returnOneRow() {
        this.setReturnType(2);
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }

    public String getQueryString() {
        return "";
    }

    public void setQueryString(String queryString) {
    }

    public void translateCustomQuery() {
        if (this.getQueryString().indexOf("#") == -1) {
            if (this.getQuery().shouldBindAllParameters() && this.getQueryString().indexOf("?") == -1) {
                return;
            }
            this.translatePureSQLCustomQuery();
            return;
        }
        int lastIndex = 0;
        boolean litteralIndex = false;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                DatabaseField field;
                String fieldName;
                int wordEndIndex;
                String token;
                int poundIndex = queryString.indexOf(35, lastIndex);
                if (poundIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token = queryString.substring(lastIndex, poundIndex);
                }
                writer.write(token);
                if (poundIndex == -1) continue;
                for (wordEndIndex = poundIndex + 1; wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1; ++wordEndIndex) {
                }
                if (queryString.charAt(poundIndex + 1) == '#') {
                    if (queryString.charAt(poundIndex + 2) == '#') {
                        if (queryString.charAt(poundIndex + 3) == '#') {
                            fieldName = queryString.substring(poundIndex + 4, wordEndIndex);
                            field = this.createField(fieldName);
                            this.appendInOut(writer, field);
                        } else {
                            fieldName = queryString.substring(poundIndex + 3, wordEndIndex);
                            field = this.createField(fieldName);
                            this.appendOut(writer, field);
                        }
                    } else {
                        fieldName = queryString.substring(poundIndex + 2, wordEndIndex);
                        field = this.createField(fieldName);
                        this.appendModify(writer, field);
                    }
                } else {
                    fieldName = queryString.substring(poundIndex + 1, wordEndIndex);
                    field = this.createField(fieldName);
                    this.appendIn(writer, field);
                }
                lastIndex = wordEndIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void translatePureSQLCustomQuery() {
        int lastIndex = 0;
        String queryString = this.getQueryString();
        int parameterIndex = 1;
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                int wordEndIndex;
                String token;
                int markIndex = queryString.indexOf(63, lastIndex);
                if (markIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token = queryString.substring(lastIndex, markIndex);
                    lastIndex = markIndex + 1;
                }
                writer.write(token);
                if (markIndex == -1) continue;
                for (wordEndIndex = markIndex + 1; wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1; ++wordEndIndex) {
                }
                if (wordEndIndex > markIndex + 1) {
                    String fieldName = queryString.substring(markIndex + 1, wordEndIndex);
                    DatabaseField field = this.createField(fieldName);
                    this.appendIn(writer, field);
                    lastIndex = wordEndIndex;
                    continue;
                }
                DatabaseField field = this.createField(String.valueOf(parameterIndex));
                ++parameterIndex;
                this.appendIn(writer, field);
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.setQueryString(((Object)writer).toString());
    }

    protected DatabaseField createField(String fieldName) {
        return new DatabaseField(fieldName);
    }

    public void appendLiteral(Writer writer, Object literal) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(literal);
        this.getParameterTypes().addElement(LITERAL);
    }

    public void appendTranslation(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(modifyField);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void appendModify(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(modifyField);
        this.getParameterTypes().addElement(MODIFY);
    }

    public void appendIn(Writer writer, DatabaseField field) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(field);
        this.getParameterTypes().addElement(IN);
    }

    public void appendInOut(Writer writer, DatabaseField inoutField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().addElement(inOut);
        this.getParameterTypes().addElement(INOUT);
    }

    public void appendOut(Writer writer, DatabaseField outField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().addElement(outField);
        this.getParameterTypes().addElement(OUT);
    }

    public void appendParameter(Writer writer, Object parameter, AbstractSession session) {
        session.getDatasourcePlatform().appendParameter(this, writer, parameter);
    }

    protected char argumentMarker() {
        return '?';
    }

    protected String whitespace() {
        return ",); \n\t:";
    }

    public void translateQueryString(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (this.getQueryString().indexOf(this.argumentMarker()) == -1) {
            return;
        }
        if (this.getParameters().isEmpty()) {
            return;
        }
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            Vector parameterFields = this.getParameters();
            this.setParameters(null);
            while (lastIndex != -1) {
                Object parameter;
                Object value;
                DatabaseField field;
                String token;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token = queryString.substring(lastIndex, tokenIndex);
                }
                writer.write(token);
                if (tokenIndex == -1) continue;
                Integer parameterType = (Integer)this.getParameterTypes().elementAt(parameterIndex);
                if (parameterType == MODIFY) {
                    field = (DatabaseField)parameterFields.elementAt(parameterIndex);
                    value = modifyRow.get(field);
                    this.appendParameter(writer, value, session);
                } else if (parameterType == CUSTOM_MODIFY) {
                    field = (DatabaseField)parameterFields.elementAt(parameterIndex);
                    value = modifyRow.get(field);
                    if (value != null) {
                        value = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value, field, false);
                    }
                    this.appendParameter(writer, value, session);
                } else if (parameterType == TRANSLATION) {
                    parameter = parameterFields.elementAt(parameterIndex);
                    value = null;
                    if (parameter instanceof ParameterExpression) {
                        value = ((ParameterExpression)parameter).getValue(translationRow, session);
                    } else {
                        DatabaseField field2 = (DatabaseField)parameter;
                        value = translationRow.get(field2);
                        if (value == null && modifyRow != null) {
                            value = modifyRow.get(field2);
                        }
                    }
                    this.appendParameter(writer, value, session);
                } else if (parameterType == LITERAL) {
                    Object value2 = parameterFields.elementAt(parameterIndex);
                    if (value2 instanceof DatabaseField) {
                        value2 = null;
                    }
                    this.appendParameter(writer, value2, session);
                } else if (parameterType == IN) {
                    parameter = parameterFields.elementAt(parameterIndex);
                    value = this.getValueForInParameter(parameter, translationRow, modifyRow, session, false);
                    this.appendParameter(writer, value, session);
                } else if (parameterType == INOUT) {
                    parameter = parameterFields.elementAt(parameterIndex);
                    value = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                    this.appendParameter(writer, value, session);
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected Object getValueForInParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session, boolean shouldBind) {
        Object value = parameter;
        if (parameter instanceof ParameterExpression) {
            value = ((ParameterExpression)parameter).getValue(translationRow, session);
        } else if (parameter instanceof DatabaseField) {
            DatabaseField modifyField;
            DatabaseField field = (DatabaseField)parameter;
            value = translationRow.get(field);
            if (modifyRow != null) {
                if (value == null) {
                    value = modifyRow.get(field);
                }
                if (value != null && (modifyField = modifyRow.getField(field)) != null && session.getDatasourcePlatform().shouldUseCustomModifyForCall(modifyField)) {
                    value = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value, modifyField, shouldBind);
                }
            }
            if (value == null && shouldBind) {
                if (field.getType() != null) {
                    value = field;
                } else if (modifyRow != null && (modifyField = modifyRow.getField(field)) != null && modifyField.getType() != null) {
                    value = modifyField;
                }
                if (value == null) {
                    DatabaseField translationField = translationRow.getField(field);
                    if (translationField == null) {
                        throw QueryException.namedArgumentNotFoundInQueryParameters(field.getName());
                    }
                    if (translationField.getType() != null) {
                        value = translationField;
                    }
                }
            }
        }
        return value;
    }

    protected Object getValueForInOutParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        Object inParameter = ((Object[])parameter)[0];
        Object inValue = this.getValueForInParameter(inParameter, translationRow, modifyRow, session, true);
        Object outParameter = ((Object[])parameter)[1];
        return this.createInOutParameter(inValue, outParameter, session);
    }

    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        Object[] inOut = new Object[]{inValue, outParameter};
        return inOut;
    }
}

