/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.ejb.cmp3.persistence.PersistenceUnitProcessor;
import oracle.toplink.essentials.exceptions.EntityManagerSetupException;
import oracle.toplink.essentials.exceptions.IntegrityException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.essentials.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.essentials.internal.ejb.cmp3.base.PropertiesHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.jdbc.base.DataSourceImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.helper.EJB30ConversionManager;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.internal.security.SecurableObjectHolder;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.internal.weaving.TransformerFactory;
import oracle.toplink.essentials.jndi.JNDIConnector;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLog;
import oracle.toplink.essentials.platform.server.CustomServerPlatform;
import oracle.toplink.essentials.platform.server.ServerPlatform;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.DatasourceLogin;
import oracle.toplink.essentials.sessions.DefaultConnector;
import oracle.toplink.essentials.sessions.ExternalTransactionController;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.threetier.ReadConnectionPool;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.sessionconfiguration.DescriptorCustomizer;
import oracle.toplink.essentials.tools.sessionconfiguration.SessionCustomizer;
import oracle.toplink.essentials.tools.sessionmanagement.SessionManager;

public class EntityManagerSetupImpl {
    protected MetadataProcessor processor = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected Map predeployProperties = null;
    protected int factoryCount = 0;
    protected ServerSession session = null;
    protected boolean isInContainerMode = false;
    protected boolean enableLazyForOneToOne = false;
    protected SecurableObjectHolder securableObjectHolder = new SecurableObjectHolder();
    public static final String STATE_INITIAL = "Initial";
    public static final String STATE_PREDEPLOYED = "Predeployed";
    public static final String STATE_DEPLOYED = "Deployed";
    public static final String STATE_PREDEPLOY_FAILED = "PredeployFailed";
    public static final String STATE_DEPLOY_FAILED = "DeployFailed";
    public static final String STATE_UNDEPLOYED = "Undeployed";
    protected String state = "Initial";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";

    protected void removeSessionFromGlobalSessionManager() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                this.session.logout();
            }
            SessionManager.getManager().getSessions().remove(this.session.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession deploy(ClassLoader realClassLoader, Map additionalProperties) {
        ServerSession serverSession;
        if (this.state != STATE_PREDEPLOYED && this.state != STATE_DEPLOYED) {
            throw new PersistenceException(EntityManagerSetupException.cannotDeployWithoutPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state));
        }
        this.session.log(1, "properties", "deploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        try {
            Map deployProperties = EntityManagerFactoryProvider.mergeMaps(additionalProperties, this.predeployProperties);
            EntityManagerFactoryProvider.translateOldProperties(deployProperties, this.session);
            if (this.state == STATE_PREDEPLOYED) {
                serverSession = this.session;
                synchronized (serverSession) {
                    if (this.state == STATE_PREDEPLOYED) {
                        try {
                            this.session.getProject().convertClassNamesToClasses(realClassLoader);
                            this.processor.setClassLoader(realClassLoader);
                            this.processor.addEntityListeners();
                            this.processor.addNamedQueries();
                            this.processor.cleanup();
                            this.processor = null;
                            this.initServerSession(deployProperties);
                            if (this.session.getIntegrityChecker().hasErrors()) {
                                this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
                            }
                            this.session.getDatasourcePlatform().getConversionManager().setLoader(realClassLoader);
                            this.state = STATE_DEPLOYED;
                        }
                        catch (RuntimeException ex) {
                            this.state = STATE_DEPLOY_FAILED;
                            throw new PersistenceException(EntityManagerSetupException.deployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), ex));
                        }
                    }
                }
            }
            if (!this.session.isConnected()) {
                serverSession = this.session;
                synchronized (serverSession) {
                    if (!this.session.isConnected()) {
                        this.updateServerSession(deployProperties, realClassLoader);
                        if (this.isValidationOnly(deployProperties, false)) {
                            this.session.initializeDescriptors();
                        } else {
                            EntityManagerFactoryProvider.login(this.session, deployProperties);
                            EntityManagerFactoryProvider.generateDDLFiles(this.session, deployProperties, !this.isInContainerMode);
                        }
                    }
                }
            }
            serverSession = this.session;
        }
        catch (ValidationException exception) {
            try {
                throw new PersistenceException(exception);
            }
            catch (Throwable throwable) {
                this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                throw throwable;
            }
        }
        this.session.log(1, "properties", "deploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        return serverSession;
    }

    protected void addProjectToSession(ServerSession session, Project project) {
        DatasourcePlatform sessionPlatform = (DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform projectPlatform = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!sessionPlatform.hasDefaultSequence() && projectPlatform.hasDefaultSequence()) {
            sessionPlatform.setDefaultSequence(projectPlatform.getDefaultSequence());
        }
        if (sessionPlatform.getSequences() == null || sessionPlatform.getSequences().isEmpty()) {
            if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
                sessionPlatform.setSequences(projectPlatform.getSequences());
            }
        } else if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
            for (Sequence sequence : projectPlatform.getSequences().values()) {
                if (sessionPlatform.getSequences().containsKey(sequence.getName())) continue;
                sessionPlatform.addSequence(sequence);
            }
        }
        session.addDescriptors(project);
    }

    protected void addSessionToGlobalSessionManager() {
        AbstractSession oldSession = (AbstractSession)SessionManager.getManager().getSessions().get(this.session.getName());
        if (oldSession != null) {
            throw new PersistenceException(EntityManagerSetupException.attemptedRedeployWithoutClose(this.session.getName()));
        }
        SessionManager.getManager().addSession(this.session);
    }

    protected void assignCMP3Policy() {
        Project project = this.session.getProject();
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            if (descriptor.getCMPPolicy() != null) continue;
            descriptor.setCMPPolicy(new CMP3Policy());
        }
    }

    protected boolean updateServerPlatform(Map m, ClassLoader loader) {
        String serverPlatformClassName = PropertiesHandler.getPropertyValueLogDebug("toplink.target-server", m, this.session);
        if (serverPlatformClassName == null) {
            return false;
        }
        ServerPlatform originalServerPlatform = this.session.getServerPlatform();
        String originalServerPlatformClassName = originalServerPlatform.getClass().getName();
        if (originalServerPlatformClassName.equals(serverPlatformClassName)) {
            return false;
        }
        ServerPlatform serverPlatform = null;
        Class cls = EntityManagerSetupImpl.findClassForProperty(serverPlatformClassName, "toplink.target-server", loader);
        try {
            Constructor constructor = cls.getConstructor(DatabaseSessionImpl.class);
            serverPlatform = (ServerPlatform)constructor.newInstance(this.session);
        }
        catch (Exception ex) {
            if (ExternalTransactionController.class.isAssignableFrom(cls)) {
                if (originalServerPlatform.getClass().equals(CustomServerPlatform.class)) {
                    CustomServerPlatform originalCustomServerPlatform = (CustomServerPlatform)originalServerPlatform;
                    if (!cls.equals(originalCustomServerPlatform.getExternalTransactionControllerClass())) {
                        originalCustomServerPlatform.setExternalTransactionControllerClass(cls);
                    }
                } else {
                    CustomServerPlatform customServerPlatform = new CustomServerPlatform(this.session);
                    customServerPlatform.setExternalTransactionControllerClass(cls);
                    serverPlatform = customServerPlatform;
                }
            }
            throw EntityManagerSetupException.failedToInstantiateServerPlatform(serverPlatformClassName, "toplink.target-server", ex);
        }
        if (serverPlatform != null) {
            this.session.setServerPlatform(serverPlatform);
            return true;
        }
        return false;
    }

    protected void updateLoggers(Map m, boolean serverPlatformChanged, boolean sessionNameChanged, ClassLoader loader) {
        String loggerClassName = PropertiesHandler.getPropertyValueLogDebug("toplink.logging.logger", m, this.session);
        SessionLog singletonLog = null;
        SessionLog sessionLog = null;
        if (loggerClassName != null) {
            SessionLog currentLog = this.session.getSessionLog();
            if (!currentLog.getClass().getName().equals(loggerClassName)) {
                Class sessionLogClass = EntityManagerSetupImpl.findClassForProperty(loggerClassName, "toplink.logging.logger", loader);
                try {
                    singletonLog = (SessionLog)sessionLogClass.newInstance();
                    sessionLog = (SessionLog)sessionLogClass.newInstance();
                }
                catch (Exception ex) {
                    throw EntityManagerSetupException.failedToInstantiateLogger(loggerClassName, "toplink.logging.logger", ex);
                }
            }
        } else if (serverPlatformChanged) {
            ServerPlatform serverPlatform = this.session.getServerPlatform();
            singletonLog = serverPlatform.getServerLog();
            sessionLog = serverPlatform.getServerLog();
        }
        if (singletonLog != null && sessionLog != null) {
            AbstractSessionLog.setLog(singletonLog);
            this.session.setSessionLog(sessionLog);
        } else if (sessionNameChanged) {
            this.session.getSessionLog().setSession(this.session);
        }
        this.initOrUpdateLogging(m, AbstractSessionLog.getLog());
        this.initOrUpdateLogging(m, this.session.getSessionLog());
    }

    protected static Class findClass(String className, ClassLoader loader) throws ClassNotFoundException, PrivilegedActionException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, loader));
        }
        return PrivilegedAccessHelper.getClassForName(className, true, loader);
    }

    protected static Class findClassForProperty(String className, String propertyName, ClassLoader loader) {
        try {
            return EntityManagerSetupImpl.findClass(className, loader);
        }
        catch (PrivilegedActionException exception1) {
            throw EntityManagerSetupException.classNotFoundForProperty(className, propertyName, exception1.getException());
        }
        catch (ClassNotFoundException exception2) {
            throw EntityManagerSetupException.classNotFoundForProperty(className, propertyName, exception2);
        }
    }

    protected void updateDescriptorCacheSettings(Map m, ClassLoader loader) {
        Map typeMap = PropertiesHandler.getPrefixValuesLogDebug("toplink.cache.type.", m, this.session);
        Map sizeMap = PropertiesHandler.getPrefixValuesLogDebug("toplink.cache.size.", m, this.session);
        Map sharedMap = PropertiesHandler.getPrefixValuesLogDebug("toplink.cache.shared.", m, this.session);
        if (typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty()) {
            return;
        }
        boolean hasDefault = false;
        String defaultTypeName = (String)typeMap.remove("default");
        Class defaultType = null;
        if (defaultTypeName != null) {
            defaultType = EntityManagerSetupImpl.findClassForProperty(defaultTypeName, "toplink.cache.type.default", loader);
            hasDefault = true;
        }
        String defaultSizeString = (String)sizeMap.remove("default");
        Integer defaultSize = null;
        if (defaultSizeString != null) {
            defaultSize = Integer.parseInt(defaultSizeString);
            hasDefault = true;
        }
        String defaultSharedString = (String)sharedMap.remove("default");
        Boolean defaultShared = null;
        if (defaultSharedString != null) {
            defaultShared = Boolean.parseBoolean(defaultSharedString);
            hasDefault = true;
        }
        Iterator it = this.session.getDescriptors().values().iterator();
        while (!(!it.hasNext() || !hasDefault && typeMap.isEmpty() && sizeMap.isEmpty() && sharedMap.isEmpty())) {
            ClassDescriptor descriptor = (ClassDescriptor)it.next();
            if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) continue;
            String entityName = descriptor.getAlias();
            String className = descriptor.getJavaClass().getName();
            Class type = defaultType;
            String name = entityName;
            String typeName = (String)typeMap.remove(name);
            if (typeName == null) {
                name = className;
                typeName = (String)typeMap.remove(name);
            }
            if (typeName != null) {
                type = EntityManagerSetupImpl.findClassForProperty(typeName, "toplink.cache.type." + name, loader);
            }
            if (type != null) {
                descriptor.setIdentityMapClass(type);
            }
            Integer size = defaultSize;
            name = entityName;
            String sizeString = (String)sizeMap.remove(name);
            if (sizeString == null) {
                name = className;
                sizeString = (String)sizeMap.remove(name);
            }
            if (sizeString != null) {
                size = Integer.parseInt(sizeString);
            }
            if (size != null) {
                descriptor.setIdentityMapSize(size);
            }
            Boolean shared = defaultShared;
            name = entityName;
            String sharedString = (String)sharedMap.remove(name);
            if (sharedString == null) {
                name = className;
                sharedString = (String)sharedMap.remove(name);
            }
            if (sharedString != null) {
                shared = Boolean.parseBoolean(sharedString);
            }
            if (shared == null) continue;
            descriptor.setIsIsolated(shared == false);
        }
    }

    public synchronized ClassTransformer predeploy(PersistenceUnitInfo info, Map extendedProperties) {
        if (this.state == STATE_DEPLOY_FAILED) {
            throw new PersistenceException(EntityManagerSetupException.cannotPredeploy(this.persistenceUnitInfo.getPersistenceUnitName(), this.state));
        }
        if (this.state == STATE_PREDEPLOYED || this.state == STATE_DEPLOYED) {
            this.session.log(1, "properties", "predeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            ++this.factoryCount;
            if (this.session != null) {
                this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            }
            return null;
        }
        if (this.state == STATE_INITIAL || this.state == STATE_UNDEPLOYED) {
            this.persistenceUnitInfo = info;
        }
        try {
            ClassLoader privateClassLoader = this.persistenceUnitInfo.getNewTempClassLoader();
            this.session = new ServerSession(new Project(new DatabaseLogin()));
            this.predeployProperties = EntityManagerFactoryProvider.mergeMaps(extendedProperties, this.persistenceUnitInfo.getProperties());
            EntityManagerFactoryProvider.translateOldProperties(this.predeployProperties, null);
            ClassLoader realClassLoader = this.persistenceUnitInfo.getClassLoader();
            this.setServerSessionName(this.predeployProperties);
            this.updateServerPlatform(this.predeployProperties, realClassLoader);
            this.updateLoggers(this.predeployProperties, true, false, realClassLoader);
            EntityManagerFactoryProvider.warnOldProperties(this.predeployProperties, this.session);
            this.session.getPlatform().setConversionManager(new EJB30ConversionManager());
            PersistenceUnitTransactionType transactionType = null;
            String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", this.predeployProperties, this.session);
            if (transTypeString != null) {
                transactionType = PersistenceUnitTransactionType.valueOf(transTypeString);
            } else if (this.persistenceUnitInfo != null) {
                transactionType = this.persistenceUnitInfo.getTransactionType();
            }
            if (!this.isValidationOnly(this.predeployProperties, false) && this.persistenceUnitInfo != null && transactionType == PersistenceUnitTransactionType.JTA && this.predeployProperties.get("javax.persistence.jtaDataSource") == null && this.persistenceUnitInfo.getJtaDataSource() == null) {
                throw new PersistenceException(EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource(this.persistenceUnitInfo.getPersistenceUnitName()));
            }
            if (this.state == STATE_INITIAL || this.state == STATE_UNDEPLOYED) {
                this.enableLazyForOneToOne = true;
                String weaving = this.getConfigPropertyAsString("toplink.weaving");
                if (weaving != null && weaving.equalsIgnoreCase("false")) {
                    this.enableLazyForOneToOne = false;
                }
            }
            boolean throwExceptionOnFail = "true".equalsIgnoreCase(EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.orm.throw.exceptions", this.predeployProperties, "true", this.session));
            this.processor = new MetadataProcessor(this.persistenceUnitInfo, this.session, privateClassLoader, this.enableLazyForOneToOne);
            PersistenceUnitProcessor.processORMetadata(this.processor, privateClassLoader, this.session, throwExceptionOnFail);
            this.session.getProject().getLogin().setConnector(new DefaultConnector());
            if (this.session.getIntegrityChecker().hasErrors()) {
                this.session.handleException(new IntegrityException(this.session.getIntegrityChecker()));
            }
            ClassTransformer transformer = null;
            if (this.enableLazyForOneToOne) {
                Collection<Class> entities = PersistenceUnitProcessor.buildEntityList(this.processor, privateClassLoader);
                transformer = TransformerFactory.createTransformerAndModifyProject(this.session, entities, privateClassLoader);
            }
            if (this.state != STATE_INITIAL && this.state != STATE_UNDEPLOYED || this.isInContainerMode()) {
                ++this.factoryCount;
            }
            this.state = STATE_PREDEPLOYED;
            this.session.log(1, "properties", "predeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            return transformer;
        }
        catch (RuntimeException ex) {
            this.state = STATE_PREDEPLOY_FAILED;
            this.session = null;
            throw new PersistenceException(EntityManagerSetupException.predeployFailed(this.persistenceUnitInfo.getPersistenceUnitName(), ex));
        }
    }

    public String getConfigPropertyAsString(String propertyKey, String defaultValue) {
        return EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, this.predeployProperties, defaultValue, this.session);
    }

    public String getConfigPropertyAsString(String propertyKey) {
        return EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug(propertyKey, this.predeployProperties, this.session);
    }

    public String getDeployedSessionName() {
        return this.session != null ? this.session.getName() : null;
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.persistenceUnitInfo;
    }

    public boolean isValidationOnly(Map m) {
        return this.isValidationOnly(m, true);
    }

    protected boolean isValidationOnly(Map m, boolean shouldMergeMap) {
        String validationOnlyString;
        if (shouldMergeMap) {
            m = this.mergeWithExistingMap(m);
        }
        if ((validationOnlyString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.validation-only", m, this.session)) != null) {
            return Boolean.parseBoolean(validationOnlyString);
        }
        return false;
    }

    public boolean shouldGetSessionOnCreateFactory(Map m) {
        m = this.mergeWithExistingMap(m);
        return this.isValidationOnly(m, false);
    }

    protected Map mergeWithExistingMap(Map m) {
        if (this.predeployProperties != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.predeployProperties);
        }
        if (this.persistenceUnitInfo != null) {
            return EntityManagerFactoryProvider.mergeMaps(m, this.persistenceUnitInfo.getProperties());
        }
        return m;
    }

    public boolean isInContainerMode() {
        return this.isInContainerMode;
    }

    protected void updateLogins(Map m) {
        String toplinkPlatform;
        DatabaseLogin login = this.session.getLogin();
        String user = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.user", m, this.session);
        String password = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.password", m, this.session);
        if (user != null) {
            login.setUserName(user);
        }
        if (password != null) {
            login.setPassword(this.securableObjectHolder.getSecurableObject().decryptPassword(password));
        }
        if ((toplinkPlatform = PropertiesHandler.getPropertyValueLogDebug("toplink.target-database", m, this.session)) != null) {
            login.setPlatformClassName(toplinkPlatform);
        }
        PersistenceUnitTransactionType transactionType = this.persistenceUnitInfo.getTransactionType();
        String transTypeString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("javax.persistence.transactionType", m, this.session);
        if (transTypeString != null) {
            transactionType = PersistenceUnitTransactionType.valueOf(transTypeString);
        }
        DataSource jtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.jtaDataSource", this.persistenceUnitInfo.getJtaDataSource());
        DataSource nonjtaDatasource = this.getDatasourceFromProperties(m, "javax.persistence.nonJtaDataSource", this.persistenceUnitInfo.getNonJtaDataSource());
        if (this.isValidationOnly(m, false) && transactionType == PersistenceUnitTransactionType.JTA && jtaDatasource == null) {
            this.updateLoginDefaultConnector(login, m);
            return;
        }
        login.setUsesExternalTransactionController(transactionType == PersistenceUnitTransactionType.JTA);
        DataSource mainDatasource = null;
        DataSource readDatasource = null;
        if (login.shouldUseExternalTransactionController()) {
            mainDatasource = jtaDatasource;
            readDatasource = nonjtaDatasource;
        } else {
            if (jtaDatasource != null) {
                this.session.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (nonjtaDatasource != null) {
                mainDatasource = nonjtaDatasource;
            } else {
                this.updateLoginDefaultConnector(login, m);
                return;
            }
        }
        if (!(login.getConnector() instanceof JNDIConnector)) {
            JNDIConnector jndiConnector = mainDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)mainDatasource).getName()) : new JNDIConnector(mainDatasource);
            login.setConnector(jndiConnector);
            login.setUsesExternalConnectionPooling(true);
        }
        if (readDatasource != null) {
            DatasourceLogin readLogin = (DatasourceLogin)login.clone();
            readLogin.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = readDatasource instanceof DataSourceImpl ? new JNDIConnector(((DataSourceImpl)readDatasource).getName()) : new JNDIConnector(readDatasource);
            readLogin.setConnector(jndiConnector);
            this.session.setReadConnectionPool(readLogin);
        }
    }

    protected DataSource getDatasourceFromProperties(Map m, String property, DataSource defaultDataSource) {
        Object datasource = EntityManagerFactoryProvider.getConfigPropertyLogDebug(property, m, this.session);
        if (datasource == null) {
            return defaultDataSource;
        }
        if (datasource instanceof String) {
            return new DataSourceImpl((String)datasource, null, null, null);
        }
        if (!(datasource instanceof DataSource)) {
            this.session.log(6, "properties", "invalid_datasource_property_value", property, datasource);
            return defaultDataSource;
        }
        return (DataSource)datasource;
    }

    protected void updateLoginDefaultConnector(DatasourceLogin login, Map m) {
        if (login.getConnector() instanceof DefaultConnector) {
            DatabaseLogin dbLogin = (DatabaseLogin)login;
            String jdbcDriver = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.driver", m, this.session);
            String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.url", m, this.session);
            if (connectionString != null) {
                dbLogin.setConnectionString(connectionString);
            }
            if (jdbcDriver != null) {
                dbLogin.setDriverClassName(jdbcDriver);
            }
        }
    }

    protected void updatePools(Map m) {
        if (!this.session.getDefaultConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            String strWriteMax;
            String strWriteMin = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.write-connections.min", m, this.session);
            if (strWriteMin != null) {
                this.session.getDefaultConnectionPool().setMinNumberOfConnections(Integer.parseInt(strWriteMin));
            }
            if ((strWriteMax = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.write-connections.max", m, this.session)) != null) {
                this.session.getDefaultConnectionPool().setMaxNumberOfConnections(Integer.parseInt(strWriteMax));
            }
        }
        if (!this.session.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
            boolean sessionUsesShared;
            boolean shouldUseShared;
            String strShouldUseShared;
            String strReadMax;
            String strReadMin = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.read-connections.min", m, this.session);
            if (strReadMin != null) {
                this.session.getReadConnectionPool().setMinNumberOfConnections(Integer.parseInt(strReadMin));
            }
            if ((strReadMax = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.read-connections.max", m, this.session)) != null) {
                this.session.getReadConnectionPool().setMaxNumberOfConnections(Integer.parseInt(strReadMax));
            }
            if ((strShouldUseShared = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.read-connections.shared", m, this.session)) != null && (shouldUseShared = Boolean.parseBoolean(strShouldUseShared)) != (sessionUsesShared = this.session.getReadConnectionPool() instanceof ReadConnectionPool)) {
                Login readLogin = this.session.getReadConnectionPool().getLogin();
                int nReadMin = this.session.getReadConnectionPool().getMinNumberOfConnections();
                int nReadMax = this.session.getReadConnectionPool().getMaxNumberOfConnections();
                if (shouldUseShared) {
                    this.session.useReadConnectionPool(nReadMin, nReadMax);
                } else {
                    this.session.useExclusiveReadConnectionPool(nReadMin, nReadMax);
                }
                this.session.getReadConnectionPool().setLogin(readLogin);
            }
        }
    }

    protected void initServerSession(Map m) {
        this.assignCMP3Policy();
        this.addSessionToGlobalSessionManager();
        if (EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.jdbc.bind-parameters", m) == null) {
            this.session.getPlatform().setShouldBindAllParameters(true);
        }
        if (PropertiesHandler.getPrefixedPropertyValue("toplink.cache.size.", "default", m) == null) {
            int defaultCacheSize = Integer.parseInt(PropertiesHandler.getDefaultPropertyValue("toplink.cache.size."));
            Iterator descriptorsIterator = this.session.getDescriptors().values().iterator();
            while (descriptorsIterator.hasNext()) {
                ((ClassDescriptor)descriptorsIterator.next()).setIdentityMapSize(defaultCacheSize);
            }
        }
    }

    protected void setServerSessionName(Map m) {
        String name = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.session-name", m);
        if (name == null) {
            name = this.persistenceUnitInfo.getPersistenceUnitRootUrl() != null ? this.persistenceUnitInfo.getPersistenceUnitRootUrl().toString() + "-" + this.persistenceUnitInfo.getPersistenceUnitName() : this.persistenceUnitInfo.getPersistenceUnitName();
        }
        this.session.setName(name);
    }

    protected void updateServerSession(Map m, ClassLoader loader) {
        if (this.session == null || this.session.isConnected()) {
            return;
        }
        boolean serverPlatformChanged = this.updateServerPlatform(m, loader);
        boolean sessionNameChanged = this.updateSessionName(m);
        this.updateLoggers(m, serverPlatformChanged, sessionNameChanged, loader);
        String shouldBindString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.jdbc.bind-parameters", m, this.session);
        if (shouldBindString != null) {
            this.session.getPlatform().setShouldBindAllParameters(Boolean.parseBoolean(shouldBindString));
        }
        this.updateLogins(m);
        if (!this.session.getLogin().shouldUseExternalTransactionController()) {
            this.session.getServerPlatform().disableJTA();
        }
        this.updatePools(m);
        this.updateDescriptorCacheSettings(m, loader);
        this.processDescriptorCustomizers(m, loader);
        this.processSessionCustomizer(m, loader);
    }

    public void setIsInContainerMode(boolean isInContainerMode) {
        this.isInContainerMode = isInContainerMode;
    }

    protected void processSessionCustomizer(Map m, ClassLoader loader) {
        String sessionCustomizerClassName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.session.customizer", m, this.session);
        if (sessionCustomizerClassName == null) {
            return;
        }
        Class sessionCustomizerClass = EntityManagerSetupImpl.findClassForProperty(sessionCustomizerClassName, "toplink.session.customizer", loader);
        try {
            SessionCustomizer sessionCustomizer = (SessionCustomizer)sessionCustomizerClass.newInstance();
            sessionCustomizer.customize(this.session);
        }
        catch (Exception ex) {
            throw EntityManagerSetupException.failedWhileProcessingProperty("toplink.session.customizer", sessionCustomizerClassName, ex);
        }
    }

    protected void initOrUpdateLogging(Map m, SessionLog log) {
        String exString;
        String sessionString;
        String threadString;
        String tsString;
        String logLevelString = PropertiesHandler.getPropertyValueLogDebug("toplink.logging.level", m, this.session);
        if (logLevelString != null) {
            log.setLevel(AbstractSessionLog.translateStringToLoggingLevel(logLevelString));
        }
        if ((tsString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.logging.timestamp", m, this.session)) != null) {
            log.setShouldPrintDate(Boolean.parseBoolean(tsString));
        }
        if ((threadString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.logging.thread", m, this.session)) != null) {
            log.setShouldPrintThread(Boolean.parseBoolean(threadString));
        }
        if ((sessionString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.logging.session", m, this.session)) != null) {
            log.setShouldPrintSession(Boolean.parseBoolean(sessionString));
        }
        if ((exString = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.logging.exceptions", m, this.session)) != null) {
            log.setShouldLogExceptionStackTrace(Boolean.parseBoolean(exString));
        }
    }

    protected boolean updateSessionName(Map m) {
        String newName = EntityManagerFactoryProvider.getConfigPropertyAsStringLogDebug("toplink.session-name", m, this.session);
        if (newName == null || newName.equals(this.session.getName())) {
            return false;
        }
        this.removeSessionFromGlobalSessionManager();
        this.session.setName(newName);
        this.addSessionToGlobalSessionManager();
        return true;
    }

    protected void processDescriptorCustomizers(Map m, ClassLoader loader) {
        Map customizerMap = PropertiesHandler.getPrefixValuesLogDebug("toplink.descriptor.customizer.", m, this.session);
        if (customizerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : customizerMap.entrySet()) {
            String name = (String)entry.getKey();
            ClassDescriptor descriptor = this.session.getDescriptorForAlias(name);
            if (descriptor == null) {
                try {
                    Class javaClass = EntityManagerSetupImpl.findClass(name, loader);
                    descriptor = this.session.getDescriptor(javaClass);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (descriptor == null) continue;
            String customizerClassName = (String)entry.getValue();
            Class customizerClass = EntityManagerSetupImpl.findClassForProperty(customizerClassName, "toplink.descriptor.customizer." + name, loader);
            try {
                DescriptorCustomizer customizer = (DescriptorCustomizer)customizerClass.newInstance();
                customizer.customize(descriptor);
            }
            catch (Exception ex) {
                throw EntityManagerSetupException.failedWhileProcessingProperty("toplink.descriptor.customizer." + name, customizerClassName, ex);
            }
        }
    }

    public boolean isInitial() {
        return this.state == STATE_INITIAL;
    }

    public boolean isPredeployed() {
        return this.state == STATE_PREDEPLOYED;
    }

    public boolean isDeployed() {
        return this.state == STATE_DEPLOYED;
    }

    public boolean isUndeployed() {
        return this.state == STATE_UNDEPLOYED;
    }

    public boolean isPredeployFailed() {
        return this.state == STATE_PREDEPLOY_FAILED;
    }

    public boolean isDeployFailed() {
        return this.state == STATE_DEPLOY_FAILED;
    }

    public int getFactoryCount() {
        return this.factoryCount;
    }

    public boolean shouldRedeploy() {
        return this.state == STATE_UNDEPLOYED || this.state == STATE_PREDEPLOY_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void undeploy() {
        block7: {
            if (this.state == STATE_INITIAL || this.state == STATE_PREDEPLOY_FAILED || this.state == STATE_UNDEPLOYED) {
                return;
            }
            this.session.log(1, "properties", "undeploy_begin", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            try {
                --this.factoryCount;
                if (this.factoryCount <= 0) break block7;
            }
            catch (Throwable throwable) {
                this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
                if (this.state == STATE_UNDEPLOYED) {
                    this.session = null;
                }
                throw throwable;
            }
            this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
            if (this.state == STATE_UNDEPLOYED) {
                this.session = null;
            }
            return;
        }
        this.state = STATE_UNDEPLOYED;
        this.removeSessionFromGlobalSessionManager();
        this.session.log(1, "properties", "undeploy_end", new Object[]{this.getPersistenceUnitInfo().getPersistenceUnitName(), this.state, this.factoryCount});
        if (this.state == STATE_UNDEPLOYED) {
            this.session = null;
        }
    }
}

