/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.logging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLogEntry;

public class DefaultSessionLog
extends AbstractSessionLog
implements Serializable {
    protected String fileName;

    public DefaultSessionLog() {
        this.level = 5;
    }

    public DefaultSessionLog(Writer writer) {
        this();
        this.initialize(writer);
    }

    protected void initialize(Writer writer) {
        this.writer = writer;
    }

    public synchronized void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel())) {
            return;
        }
        try {
            this.printPrefixString(entry.getLevel());
            this.getWriter().write(this.getSupplementDetailString(entry));
            if (entry.hasException()) {
                if (entry.getLevel() == 7) {
                    entry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                } else if (entry.getLevel() <= 6) {
                    if (this.shouldLogExceptionStackTrace()) {
                        entry.getException().printStackTrace(new PrintWriter(this.getWriter()));
                    } else {
                        this.writeMessage(entry.getException().toString());
                    }
                }
            } else {
                this.writeMessage(this.formatMessage(entry));
            }
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }

    public void setWriter(String aFileName) {
        if (aFileName != null) {
            try {
                this.writer = new FileWriter(aFileName);
                this.fileName = aFileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getWriterFilename() {
        return this.fileName;
    }

    protected void writeMessage(String message) throws IOException {
        this.getWriter().write(message);
    }

    protected void writeSeparator() throws IOException {
        this.getWriter().write("--");
    }
}

