/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 * English ResourceBundle for DefaultMappingException messages.
 *
 * @author: King Wang
 * @since: OracleAS TopLink 10<i>g</i> (10.0.3)
 */
public class DefaultMappingExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "20001", "Could not find the parameter type: [{2}], defined in the ejb-jar.xml, of the finder: [{1}] in the entity bean: [{0}]." },
                                           { "20002", "The finder method: [{1}] with the parameters as: [{2}], defined in the ejb-jar.xml, is not found in the home of bean: [{0}]." },
                                           { "20003", "The ejbSelect method: [{1}] with the parameters as: [{2}], defined in the ejb-jar.xml, is not found in the bean class of bean: [{0}]." },
                                           { "20004", "The finder method: [{1}] of bean: [{0}] in ejb-jar.xml file is not well defined. It should start with either 'find' or 'ejbSelect'." },
                                           { "20005", "The abstract getter method: [{0}] is not defined in the bean: [{1}]." },
                                           { "20006", "The cmp field: [{0}] is not defined in the bean: [{1}]." }
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
