/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.List;

import javax.persistence.ManyToOne;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;

import oracle.toplink.essentials.mappings.OneToOneMapping;

/**
 * A many to one relationship accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class ManyToOneAccessor extends ObjectAccessor {    
    private ManyToOne m_manyToOne;
    
    /**
     * INTERNAL:
     */
    public ManyToOneAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        m_manyToOne = getAnnotation(ManyToOne.class);
    }
    
    /**
     * INTERNAL: (Overridden in XMLManyToOneAccessor)
     */
    public List<String> getCascadeTypes() {
        return getCascadeTypes(m_manyToOne.cascade());
    }
    
    /**
     * INTERNAL: (Overridden in XMLManyToOneAccessor)
     */
    public String getFetchType() {
        return m_manyToOne.fetch().name();
    }
    
    /**
     * INTERNAL:
     * 
     * Return the logging context for this accessor.
     */
    protected String getLoggingContext() {
        return m_logger.MANY_TO_ONE_MAPPING_REFERENCE_CLASS;
    }
    
    /**
     * INTERNAL: (Overridden in XMLManyToOneAccessor)
     */
    public Class getTargetEntity() {
        return m_manyToOne.targetEntity();
    }
    
    /**
     * INTERNAL:
     */
	public boolean isManyToOne() {
        return true;
    }
    
    /**
     * INTERNAL: (Overridden in XMLManyToOneAccessor)
     */
    public boolean isOptional() {
        return m_manyToOne.optional();
    }
    
    /**
     * INTERNAL:
     * Process a @ManyToOne or many-to-one element into a TopLink OneToOne 
     * mapping.
     */
    public void process() {
        // Initialize our mapping now with what we found.
        OneToOneMapping mapping = initOneToOneMapping();

        // Now process the JoinColumns (if there are any) for this mapping.
        processOwningMappingKeys(mapping);
        
        // Add the mapping to the descriptor.
        m_descriptor.addMapping(mapping);
    }
}
