/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.transaction;

import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

/**
 * <p>
 * <b>Purpose</b>: Generate synchronization listener objects of the appropriate type.
 * <p>
 * <b>Description</b>: This interface will be used by the AbstractTransactionController
 * to obtain a listener that it will register against the external transaction in order
 * to synchronize the unit of work.
 * All new listener classes should implement this interface.
 *
 * @see AbstractSynchronizationListener
 */
public interface SynchronizationListenerFactory {

    /**
     * INTERNAL:
     * Create and return the synchronization listener object that can be registered
     * to receive transaction notification callbacks. The type of synchronization object
     * that gets returned will be dependent upon the transaction system
     */
    public AbstractSynchronizationListener newSynchronizationListener(UnitOfWorkImpl unitOfWork, AbstractSession session, Object transaction, AbstractTransactionController controller);
}
