/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2007, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Represent a range identification variable
 * declaration as part of the FROM clause FROM Order o.
 * <p><b>Responsibilities</b>:<ul>
 * <li> Manage the abstract schema name range variable declaration. 
 * </ul>
 */
public class RangeDeclNode extends IdentificationVariableDeclNode {

    private String abstractSchemaName;
    
    /** */
    public String getAbstractSchemaName() {
        return abstractSchemaName;
    }
    
    /** */
    public void setAbstractSchemaName(String name) {
        abstractSchemaName = name;
    }
    
    /** 
     * INTERNAL 
     * Check for an unqualified field access. If abstractSchemaName does not
     * define a valid abstract schema name treat it as unqualified field
     * access. Then method qualifies the field access and use it as the path
     * expression of a new join variable declaration node returned by the
     * method. 
     */
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        String name = abstractSchemaName;
        if (typeHelper.resolveSchema(name) == null) {
            // not a known abstract schema name => make it a join node with a
            // qualified attribute access as path expression 
            context.unregisterVariable(getCanonicalVariableName());
            NodeFactory factory = context.getNodeFactory();
            Node path = (Node)factory.newQualifiedAttribute(
                getLine(), getColumn(), context.getBaseVariable(), name);
            return (Node)factory.newVariableDecl(
                getLine(), getColumn(), path, getVariableName());
        }
        return this;
    }

    /**
     * INTERNAL
     * Validate node and calculate its type.
     */
    public void validate(ParseTreeContext context) {
        super.validate(context);
        TypeHelper typeHelper = context.getTypeHelper();
        Object type = typeHelper.resolveSchema(abstractSchemaName);
        if (type == null) {
            throw EJBQLException.unknownAbstractSchemaType2(
                context.getQueryInfo(), getLine(), getColumn(), abstractSchemaName);
        }
        setType(type);
    }
}
