/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataPersistenceUnit;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataField;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataMethod;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.listeners.MetadataEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLBasicAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLEmbeddedAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLEmbeddedIdAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLManyToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLManyToOneAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLOneToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLOneToOneAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLTransientAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLDiscriminatorColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLPrimaryKeyJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.listeners.XMLEntityClassListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.listeners.XMLEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.queries.XMLNamedNativeQuery;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.queries.XMLNamedQuery;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.queries.XMLSQLResultSetMapping;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLTableGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.tables.XMLSecondaryTable;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.tables.XMLTable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLClassAccessor
extends ClassAccessor
implements XMLAccessor {
    protected Node m_node;
    protected XMLHelper m_helper;
    protected static String m_entityMappingsAccess;
    protected static String m_entityMappingsSchema;
    protected static String m_entityMappingsCatalog;

    public XMLClassAccessor(MetadataAccessibleObject accessibleObject, Node node, XMLHelper helper, MetadataProcessor processor, MetadataDescriptor descriptor) {
        super(accessibleObject, processor, descriptor);
        this.m_node = node;
        this.m_helper = helper;
    }

    protected MetadataAccessor buildAccessor(Node node) {
        MetadataAccessibleObject accessibleObject;
        String attributeName = this.m_helper.getNodeValue(node, "@name");
        if (this.m_descriptor.usesPropertyAccess()) {
            Method method = MetadataHelper.getMethodForPropertyName(attributeName, this.getJavaClass());
            if (method == null) {
                this.m_validator.throwUnableToDetermineClassForProperty(attributeName, this.getJavaClass());
            }
            accessibleObject = new MetadataMethod(method);
        } else {
            Field field = MetadataHelper.getFieldForName(attributeName, this.getJavaClass());
            if (field == null) {
                this.m_validator.throwUnableToDetermineClassForField(attributeName, this.getJavaClass());
            }
            accessibleObject = new MetadataField(field);
        }
        String nodeName = node.getLocalName();
        if (nodeName.equals("one-to-one")) {
            return new XMLOneToOneAccessor(accessibleObject, node, this);
        }
        if (nodeName.equals("many-to-one")) {
            return new XMLManyToOneAccessor(accessibleObject, node, this);
        }
        if (nodeName.equals("one-to-many")) {
            if (MetadataHelper.isSupportedCollectionClass(accessibleObject.getRawClass())) {
                return new XMLOneToManyAccessor(accessibleObject, node, this);
            }
            this.m_validator.throwInvalidCollectionTypeForRelationship(this.getJavaClass(), accessibleObject.getRawClass(), this.getAttributeName());
            return null;
        }
        if (nodeName.equals("many-to-many")) {
            if (MetadataHelper.isSupportedCollectionClass(accessibleObject.getRawClass())) {
                return new XMLManyToManyAccessor(accessibleObject, node, this);
            }
            this.m_validator.throwInvalidCollectionTypeForRelationship(this.getJavaClass(), accessibleObject.getRawClass(), this.getAttributeName());
            return null;
        }
        if (nodeName.equals("embedded")) {
            return new XMLEmbeddedAccessor(accessibleObject, node, this);
        }
        if (nodeName.equals("embedded-id")) {
            return new XMLEmbeddedIdAccessor(accessibleObject, node, this);
        }
        if (nodeName.equals("transient")) {
            return new XMLTransientAccessor(accessibleObject, node, this);
        }
        return new XMLBasicAccessor(accessibleObject, node, this);
    }

    public String getCatalog() {
        return m_entityMappingsCatalog;
    }

    public String getDiscriminatorValue() {
        String discriminatorValue = this.m_helper.getNodeTextValue(this.m_node, "discriminator-value");
        if (discriminatorValue.equals("")) {
            return super.getDiscriminatorValue();
        }
        return discriminatorValue;
    }

    public String getDocumentName() {
        return this.m_helper.getDocumentName();
    }

    public String getEntityName() {
        String entityName = this.m_helper.getNodeValue(this.m_node, "@name");
        if (entityName.equals("")) {
            return super.getEntityName();
        }
        return entityName;
    }

    public XMLHelper getHelper() {
        return this.m_helper;
    }

    protected String getInheritanceStrategy() {
        Node inheritanceNode = this.m_helper.getNode(this.m_node, "inheritance");
        if (inheritanceNode == null) {
            return super.getInheritanceStrategy();
        }
        return this.m_helper.getNodeValue(inheritanceNode, "@strategy");
    }

    protected MetadataPrimaryKeyJoinColumns getPrimaryKeyJoinColumns(String sourceTableName, String targetTableName) {
        if (this.m_helper.nodeHasPrimaryKeyJoinColumns(this.m_node)) {
            return new XMLPrimaryKeyJoinColumns(this.m_node, this.m_helper, sourceTableName, targetTableName);
        }
        return super.getPrimaryKeyJoinColumns(sourceTableName, targetTableName);
    }

    public String getSchema() {
        return m_entityMappingsSchema;
    }

    protected boolean hasEntity(Class cls) {
        Node node = this.m_helper.locateEntityNode(cls);
        if (node != null) {
            return true;
        }
        return super.hasEntity(cls);
    }

    protected boolean hasInheritance(Class entityClass) {
        Node node = this.m_helper.locateEntityNode(entityClass);
        if (node != null && this.m_helper.hasNode(node, "inheritance")) {
            return true;
        }
        return super.hasInheritance(entityClass);
    }

    public boolean isXMLAccessor() {
        return true;
    }

    public void process() {
        this.m_descriptor.setIgnoreAnnotations(this.m_helper.getNodeValue(this.m_node, "@metadata-complete", this.m_descriptor.ignoreAnnotations()));
        this.m_descriptor.setAccess(this.m_helper.getNodeValue(this.m_node, "@access", m_entityMappingsAccess));
        this.m_descriptor.setSchema(m_entityMappingsSchema);
        this.m_descriptor.setCatalog(m_entityMappingsCatalog);
        super.process();
    }

    protected ClassAccessor processAccessor(MetadataDescriptor descriptor) {
        Node node = this.m_helper.locateEntityNode(descriptor.getJavaClass());
        if (node != null) {
            XMLClassAccessor accessor = new XMLClassAccessor(new MetadataClass(descriptor.getJavaClass()), node, this.m_helper, this.m_processor, descriptor);
            descriptor.setClassAccessor(accessor);
            accessor.process();
            accessor.setIsProcessed();
            return accessor;
        }
        return super.processAccessor(descriptor);
    }

    protected void processAccessors() {
        NodeList nodes = this.m_helper.getNodes(this.m_node, "attributes", "child::*");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.processAccessor(this.buildAccessor(nodes.item(i)));
            }
        }
        super.processAccessors();
    }

    protected void processAssociationOverrides() {
        NodeList nodes = this.m_helper.getNodes(this.m_node, "association-override");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                this.processAssociationOverride(this.m_helper.getNodeValue(node, "@name"), new XMLJoinColumns(node, this.m_helper));
            }
        }
        super.processAssociationOverrides();
    }

    protected void processAttributeOverrides() {
        NodeList nodes = this.m_helper.getNodes(this.m_node, "attribute-override");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                this.processAttributeOverride(new XMLColumn(nodes.item(i), this.m_helper, this.getAnnotatedElement()));
            }
        }
        super.processAttributeOverrides();
    }

    protected void processDiscriminatorColumn() {
        Node node = this.m_helper.getNode(this.m_node, "discriminator-column");
        if (node == null) {
            super.processDiscriminatorColumn();
        } else {
            this.processDiscriminatorColumn(new XMLDiscriminatorColumn(node, this.m_helper));
        }
    }

    public MetadataEntityListener processEntityEventListener(ClassLoader loader) {
        this.m_helper.setLoader(loader);
        XMLEntityClassListener listener = new XMLEntityClassListener(this.getJavaClass());
        Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityClass(this.getJavaClass());
        this.processLifecycleEvents(listener, this.m_node, this.m_helper, candidateMethods);
        this.processCallbackMethods(candidateMethods, listener);
        return listener;
    }

    public void processEntityListeners(Class entityClass, ClassLoader loader) {
        this.m_helper.setLoader(loader);
        NodeList nodes = this.m_helper.getNodes(this.m_node, new String[]{"entity-listeners", "entity-listener"});
        if (nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                XMLEntityListener listener = new XMLEntityListener(this.m_helper.getClassForNode(node), entityClass);
                Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener);
                this.processLifecycleEvents(listener, node, this.m_helper, candidateMethods);
                this.processCallbackMethods(candidateMethods, listener);
                this.m_descriptor.addEntityListenerEventListener(listener);
            }
        } else {
            super.processEntityListeners(entityClass, loader);
        }
    }

    public void processEntityMappings() {
        NodeList sequenceGeneratorNodes;
        MetadataPersistenceUnit persistenceUnit = this.m_project.getPersistenceUnit();
        if (persistenceUnit != null) {
            m_entityMappingsAccess = this.m_helper.getNodeTextValue("entity-mappings", "access", persistenceUnit.getAccess());
            m_entityMappingsSchema = this.m_helper.getNodeTextValue("entity-mappings", "schema", persistenceUnit.getSchema());
            m_entityMappingsCatalog = this.m_helper.getNodeTextValue("entity-mappings", "catalog", persistenceUnit.getCatalog());
        } else {
            m_entityMappingsAccess = this.m_helper.getNodeTextValue("entity-mappings", "access");
            m_entityMappingsSchema = this.m_helper.getNodeTextValue("entity-mappings", "schema");
            m_entityMappingsCatalog = this.m_helper.getNodeTextValue("entity-mappings", "catalog");
        }
        NodeList tableGeneratorNodes = this.m_helper.getNodes("entity-mappings", "table-generator");
        if (tableGeneratorNodes != null) {
            for (int i = 0; i < tableGeneratorNodes.getLength(); ++i) {
                this.processTableGenerator(tableGeneratorNodes.item(i));
            }
        }
        if ((sequenceGeneratorNodes = this.m_helper.getNodes("entity-mappings", "sequence-generator")) != null) {
            for (int i = 0; i < sequenceGeneratorNodes.getLength(); ++i) {
                this.processSequenceGenerator(sequenceGeneratorNodes.item(i));
            }
        }
        this.processNamedQueries(this.m_helper.getNodes("entity-mappings", "named-query"));
        this.processNamedNativeQueries(this.m_helper.getNodes("entity-mappings", "named-native-query"));
        this.processSqlResultSetMappings(this.m_helper.getNodes("entity-mappings", "sql-result-set-mapping"));
    }

    protected void processExcludeDefaultListeners() {
        if (this.m_helper.hasNode(this.m_node, "exclude-default-listeners")) {
            this.m_descriptor.setExcludeDefaultListeners(true);
        } else {
            super.processExcludeDefaultListeners();
        }
    }

    protected void processExcludeSuperclassListeners() {
        if (this.m_helper.hasNode(this.m_node, "exclude-superclass-listeners")) {
            this.m_descriptor.setExcludeSuperclassListeners(true);
        } else {
            super.processExcludeSuperclassListeners();
        }
    }

    protected void processIdClass() {
        Node result = this.m_helper.getNode(this.m_node, "id-class");
        if (result == null) {
            super.processIdClass();
        } else {
            this.processIdClass(this.m_helper.getClassForNode(result), "orm_warning_ignore_id_class");
        }
    }

    public void processMappedSuperclassEventListener(MetadataEntityListener listener, Class entityClass, ClassLoader loader) {
        this.m_helper.setLoader(loader);
        Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForMappedSuperclass(this.getJavaClass(), entityClass);
        this.processLifecycleEvents(listener, this.m_node, this.m_helper, candidateMethods);
        this.processCallbackMethods(candidateMethods, listener);
    }

    protected void processNamedNativeQueries() {
        this.processNamedNativeQueries(this.m_helper.getNodes(this.m_node, "named-native-query"));
        super.processNamedNativeQueries();
    }

    protected void processNamedNativeQueries(NodeList queryNodes) {
        if (queryNodes != null) {
            for (int i = 0; i < queryNodes.getLength(); ++i) {
                this.processNamedNativeQuery(new XMLNamedNativeQuery(queryNodes.item(i), this.m_helper));
            }
        }
    }

    protected void processNamedQueries() {
        this.processNamedQueries(this.m_helper.getNodes(this.m_node, "named-query"));
        super.processNamedQueries();
    }

    protected void processNamedQueries(NodeList queryNodes) {
        if (queryNodes != null) {
            for (int i = 0; i < queryNodes.getLength(); ++i) {
                this.processNamedQuery(new XMLNamedQuery(queryNodes.item(i), this.m_helper));
            }
        }
    }

    protected void processSecondaryTables() {
        NodeList secondaryTables = this.m_helper.getNodes(this.m_node, "secondary-table");
        if (secondaryTables == null) {
            super.processSecondaryTables();
        } else if (this.m_descriptor.ignoreTables()) {
            this.m_logger.logWarningMessage("orm_warning_ignore_secondary_table", this.getJavaClass());
        } else {
            for (int i = 0; i < secondaryTables.getLength(); ++i) {
                this.processSecondaryTable(new XMLSecondaryTable(secondaryTables.item(i), this.m_helper, this.m_logger));
            }
        }
    }

    protected void processSequenceGenerator() {
        this.processSequenceGenerator(this.m_helper.getNode(this.m_node, "sequence-generator"));
        super.processSequenceGenerator();
    }

    protected void processSequenceGenerator(Node node) {
        if (node != null) {
            this.processSequenceGenerator(new XMLSequenceGenerator(node, this.m_helper));
        }
    }

    protected void processSqlResultSetMappings() {
        this.processSqlResultSetMappings(this.m_helper.getNodes(this.m_node, "sql-result-set-mapping"));
        super.processSqlResultSetMappings();
    }

    protected void processSqlResultSetMappings(NodeList sqlResultSetNodes) {
        if (sqlResultSetNodes != null) {
            int nodeCount = sqlResultSetNodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                this.processSqlResultSetMapping(new XMLSQLResultSetMapping(sqlResultSetNodes.item(i), this.m_helper));
            }
        }
    }

    protected void processTable() {
        Node tableNode = this.m_helper.getNode(this.m_node, "table");
        if (tableNode != null) {
            if (this.m_descriptor.ignoreTables()) {
                this.m_logger.logWarningMessage("orm_warning_ignore_table", this.getJavaClass());
            } else {
                this.processTable(new XMLTable(tableNode, this.m_helper, this.m_logger));
            }
        } else {
            super.processTable();
        }
    }

    protected void processTableGenerator() {
        this.processTableGenerator(this.m_helper.getNode(this.m_node, "table-generator"));
        super.processTableGenerator();
    }

    protected void processTableGenerator(Node node) {
        if (node != null) {
            this.processTableGenerator(new XMLTableGenerator(node, this));
        }
    }
}

