/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.datastructure.impl;

import java.util.Iterator;
import org.wikidata.wdtk.storage.datastructure.impl.BitVectorImpl;
import org.wikidata.wdtk.storage.datastructure.impl.CountBitsArray;
import org.wikidata.wdtk.storage.datastructure.impl.FindPositionArray;
import org.wikidata.wdtk.storage.datastructure.intf.BitVector;
import org.wikidata.wdtk.storage.datastructure.intf.RankedBitVector;

public class RankedBitVectorImpl
implements RankedBitVector,
Iterable<Boolean> {
    static final int defaultCountBitsBlockSize = 1024;
    static final int defaultFindPositionBlockSize = 8192;
    final BitVectorImpl bitVector;
    final CountBitsArray countBitsArray;
    final FindPositionArray findPositionOfFalse;
    final FindPositionArray findPositionOfTrue;

    public RankedBitVectorImpl() {
        this.bitVector = new BitVectorImpl();
        this.countBitsArray = new CountBitsArray(this.bitVector, 1024);
        this.findPositionOfFalse = new FindPositionArray(this.bitVector, false, 8192);
        this.findPositionOfTrue = new FindPositionArray(this.bitVector, true, 8192);
    }

    public RankedBitVectorImpl(BitVector bitVector) {
        this.bitVector = new BitVectorImpl(bitVector);
        this.countBitsArray = bitVector instanceof RankedBitVectorImpl ? new CountBitsArray(this.bitVector, ((RankedBitVectorImpl)bitVector).countBitsArray.getBlockSize()) : new CountBitsArray(this.bitVector, 1024);
        this.findPositionOfFalse = new FindPositionArray(this.bitVector, false, 8192);
        this.findPositionOfTrue = new FindPositionArray(this.bitVector, true, 8192);
    }

    public RankedBitVectorImpl(long initialSize) {
        this.bitVector = new BitVectorImpl(initialSize);
        this.countBitsArray = new CountBitsArray(this.bitVector, 1024);
        this.findPositionOfFalse = new FindPositionArray(this.bitVector, false, 8192);
        this.findPositionOfTrue = new FindPositionArray(this.bitVector, true, 8192);
    }

    public RankedBitVectorImpl(long initialSize, int countBlockSize, int findPositionBlockSize) {
        this.bitVector = new BitVectorImpl(initialSize);
        this.countBitsArray = new CountBitsArray(this.bitVector, countBlockSize);
        this.findPositionOfFalse = new FindPositionArray(this.bitVector, false, findPositionBlockSize);
        this.findPositionOfTrue = new FindPositionArray(this.bitVector, true, findPositionBlockSize);
    }

    @Override
    public boolean addBit(boolean bit) {
        boolean ret = this.bitVector.addBit(bit);
        this.notifyObservers();
        return ret;
    }

    @Override
    public long countBits(boolean bit, long position) {
        return this.countBitsArray.countBits(bit, position);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitVector)) {
            return false;
        }
        return this.bitVector.equals(obj);
    }

    @Override
    public long findPosition(boolean bit, long nOccurrence) {
        if (nOccurrence <= 0L) {
            return -1L;
        }
        return bit ? this.findPositionOfTrue.findPosition(nOccurrence) : this.findPositionOfFalse.findPosition(nOccurrence);
    }

    @Override
    public boolean getBit(long position) {
        return this.bitVector.getBit(position);
    }

    public int hashCode() {
        return this.bitVector.hashCode();
    }

    @Override
    public Iterator<Boolean> iterator() {
        return this.bitVector.iterator();
    }

    void notifyObservers() {
        this.countBitsArray.update();
        this.findPositionOfFalse.update();
        this.findPositionOfTrue.update();
    }

    @Override
    public void setBit(long position, boolean bit) {
        boolean oldBit = this.getBit(position);
        if (oldBit != bit) {
            this.bitVector.setBit(position, bit);
            this.notifyObservers();
        }
    }

    @Override
    public long size() {
        return this.bitVector.size();
    }

    public String toString() {
        return this.bitVector.toString();
    }
}

