/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.datastructure.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.wikidata.wdtk.storage.datastructure.intf.BitVector;

class CountBitsArray {
    final BitVector bitVector;
    final int blockSize;
    long[] countArray;
    boolean hasChanged;

    public CountBitsArray(BitVector bitVector, int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("The block size must be a positive number. The received value was: " + blockSize + ".");
        }
        this.bitVector = bitVector;
        this.hasChanged = true;
        this.blockSize = blockSize;
    }

    public long countBits(boolean bit, long position) {
        this.updateCount();
        int blockNumber = (int)(position / (long)this.blockSize);
        long mark = (long)blockNumber * (long)this.blockSize;
        long trueValues = 0L;
        if (blockNumber > 0) {
            trueValues = this.countArray[blockNumber - 1];
        }
        for (long index = mark; index <= position; ++index) {
            trueValues += this.bitVector.getBit(index) ? 1L : 0L;
        }
        return bit ? trueValues : position + 1L - trueValues;
    }

    int getBlockSize() {
        return this.blockSize;
    }

    List<Long> getCountList() {
        ArrayList<Long> ret = new ArrayList<Long>();
        long lastValue = 0L;
        int positionInBlock = 0;
        for (long index = 0L; index < this.bitVector.size(); ++index) {
            if (this.bitVector.getBit(index)) {
                ++lastValue;
            }
            if (++positionInBlock != this.blockSize) continue;
            ret.add(lastValue);
            positionInBlock = 0;
        }
        if (positionInBlock > 0) {
            ret.add(lastValue);
        }
        return ret;
    }

    public String toString() {
        this.updateCount();
        return Arrays.toString(this.countArray);
    }

    public void update() {
        this.hasChanged = true;
    }

    void updateCount() {
        if (this.hasChanged) {
            this.countArray = ArrayUtils.toPrimitive((Long[])this.getCountList().toArray(new Long[0]));
            this.hasChanged = false;
        }
    }
}

