/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json;

import org.json.JSONException;
import org.json.JSONObject;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.datamodel.json.DatatypeConverters;

public class ValueJsonConverter
implements ValueVisitor<JSONObject> {
    final String STD_UNIT_VALUE = "1";

    @Override
    public JSONObject visit(DatatypeIdValue value) {
        throw new UnsupportedOperationException("DatatypeIdValues cannot be converted to JSON. They are not handled as snak values in the conversion.");
    }

    @Override
    public JSONObject visit(EntityIdValue value) {
        String jsonEntityType;
        JSONObject valueResult = new JSONObject();
        valueResult.put("numeric-id", (Object)value.getId());
        switch (value.getEntityType()) {
            case "http://www.wikidata.org/ontology#Item": {
                jsonEntityType = "item";
                break;
            }
            case "http://www.wikidata.org/ontology#Property": {
                jsonEntityType = "property";
                break;
            }
            default: {
                throw new JSONException("Unsupported entity type: " + value.getEntityType());
            }
        }
        valueResult.put("entity-type", (Object)jsonEntityType);
        JSONObject result = new JSONObject();
        result.put("type", (Object)"wikibase-entityid");
        result.put("value", (Object)valueResult);
        return result;
    }

    @Override
    public JSONObject visit(GlobeCoordinatesValue value) {
        JSONObject result = new JSONObject();
        JSONObject valueResult = new JSONObject();
        result.put("value", (Object)valueResult);
        valueResult.put("latitude", (double)value.getLatitude() / 1.0E9);
        valueResult.put("longitude", (double)value.getLongitude() / 1.0E9);
        valueResult.put("precision", (double)value.getPrecision() / 1.0E9);
        valueResult.put("globe", (Object)value.getGlobe());
        result.put("type", (Object)"globecoordinate");
        return result;
    }

    @Override
    public JSONObject visit(MonolingualTextValue value) {
        JSONObject result = new JSONObject();
        result.put("language", (Object)value.getLanguageCode());
        result.put("value", (Object)value.getText());
        return result;
    }

    @Override
    public JSONObject visit(QuantityValue value) {
        JSONObject result = new JSONObject();
        JSONObject valueResult = new JSONObject();
        result.put("value", (Object)valueResult);
        valueResult.put("amount", (Object)DatatypeConverters.formatBigDecimal(value.getNumericValue()));
        valueResult.put("unit", (Object)"1");
        valueResult.put("upperBound", (Object)DatatypeConverters.formatBigDecimal(value.getUpperBound()));
        valueResult.put("lowerBound", (Object)DatatypeConverters.formatBigDecimal(value.getLowerBound()));
        result.put("type", (Object)"quantity");
        return result;
    }

    @Override
    public JSONObject visit(StringValue value) {
        JSONObject result = new JSONObject();
        result.put("value", (Object)value.getString());
        result.put("type", (Object)"string");
        return result;
    }

    @Override
    public JSONObject visit(TimeValue value) {
        JSONObject result = new JSONObject();
        JSONObject valueResult = new JSONObject();
        result.put("value", (Object)valueResult);
        valueResult.put("time", (Object)DatatypeConverters.formatTimeISO8601(value));
        valueResult.put("timezone", value.getTimezoneOffset());
        valueResult.put("before", value.getBeforeTolerance());
        valueResult.put("after", value.getAfterTolerance());
        valueResult.put("precision", (int)value.getPrecision());
        valueResult.put("calendarmodel", (Object)value.getPreferredCalendarModel());
        result.put("type", (Object)"time");
        return result;
    }
}

