/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json;

import org.json.JSONObject;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.json.ValueJsonConverter;

public class SnakJsonConverter
implements SnakVisitor<JSONObject> {
    final ValueJsonConverter valueJsonConverter;

    public SnakJsonConverter(ValueJsonConverter valueJsonConverter) {
        this.valueJsonConverter = valueJsonConverter;
    }

    @Override
    public JSONObject visit(ValueSnak snak) {
        JSONObject result = new JSONObject();
        result.put("snaktype", (Object)"value");
        result.put("property", (Object)snak.getPropertyId().getId());
        result.put("datavalue", (Object)snak.getValue().accept(this.valueJsonConverter));
        return result;
    }

    @Override
    public JSONObject visit(SomeValueSnak snak) {
        JSONObject result = new JSONObject();
        result.put("snaktype", (Object)"somevalue");
        result.put("property", (Object)snak.getPropertyId().getId());
        return result;
    }

    @Override
    public JSONObject visit(NoValueSnak snak) {
        JSONObject result = new JSONObject();
        result.put("snaktype", (Object)"novalue");
        result.put("property", (Object)snak.getPropertyId().getId());
        return result;
    }
}

