/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentsSerializer;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.json.JsonConverter;

public class JsonSerializer
implements EntityDocumentsSerializer {
    static final Logger logger = LoggerFactory.getLogger(JsonSerializer.class);
    final JsonConverter converter = new JsonConverter();
    OutputStream out;
    Boolean atFirst;

    public JsonSerializer(OutputStream out) {
        this.out = out;
        this.atFirst = true;
    }

    public void restartProcess() {
        this.atFirst = true;
    }

    void writeEntityDocument(String jsonDocument, String id) {
        StringBuilder builder = new StringBuilder();
        if (!this.atFirst.booleanValue()) {
            builder.append(",");
        } else {
            this.atFirst = false;
        }
        builder.append("\"");
        builder.append(id);
        builder.append("\"");
        builder.append(":");
        builder.append(jsonDocument);
        builder.append("\n");
        try {
            this.out.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        this.writeEntityDocument(this.converter.getJsonForItemDocument(itemDocument).toString(), itemDocument.getItemId().getId());
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        this.writeEntityDocument(this.converter.getJsonForPropertyDocument(propertyDocument).toString(), propertyDocument.getEntityId().getId());
    }

    @Override
    public void finishProcessingEntityDocuments() {
    }

    @Override
    public void start() {
        this.restartProcess();
        try {
            this.out.write("{\"entities\": {\n".getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Failed to write JSON export:" + e.toString());
            throw new RuntimeException(e.toString(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.out.write("}}".getBytes(StandardCharsets.UTF_8));
            this.out.close();
        }
        catch (IOException e) {
            logger.error("Failed to write JSON export:" + e.toString());
            throw new RuntimeException(e.toString(), e);
        }
    }
}

