/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class TimeValueImpl
implements TimeValue {
    final long year;
    final byte month;
    final byte day;
    final byte hour;
    final byte minute;
    final byte second;
    final byte precision;
    final int timezoneOffset;
    final int beforeTolerance;
    final int afterTolerance;
    final String calendarModel;

    TimeValueImpl(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        Validate.notNull((Object)calendarModel, (String)"Calendar model must not be null", (Object[])new Object[0]);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.precision = precision;
        this.beforeTolerance = beforeTolerance;
        this.afterTolerance = afterTolerance;
        this.timezoneOffset = timezoneOffset;
        this.calendarModel = calendarModel;
    }

    @Override
    public long getYear() {
        return this.year;
    }

    @Override
    public byte getMonth() {
        return this.month;
    }

    @Override
    public byte getDay() {
        return this.day;
    }

    @Override
    public byte getHour() {
        return this.hour;
    }

    @Override
    public byte getMinute() {
        return this.minute;
    }

    @Override
    public byte getSecond() {
        return this.second;
    }

    @Override
    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @Override
    public String getPreferredCalendarModel() {
        return this.calendarModel;
    }

    @Override
    public byte getPrecision() {
        return this.precision;
    }

    @Override
    public int getBeforeTolerance() {
        return this.beforeTolerance;
    }

    @Override
    public int getAfterTolerance() {
        return this.afterTolerance;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + new Long(this.year).hashCode();
        result = 31 * result + this.month;
        result = 31 * result + this.day;
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        result = 31 * result + this.second;
        result = 31 * result + this.precision;
        result = 31 * result + this.beforeTolerance;
        result = 31 * result + this.afterTolerance;
        result = 31 * result + this.timezoneOffset;
        result = 31 * result + this.calendarModel.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeValueImpl)) {
            return false;
        }
        TimeValueImpl other = (TimeValueImpl)obj;
        return this.year == other.year && this.month == other.month && this.day == other.day && this.hour == other.hour && this.minute == other.minute && this.second == other.second && this.precision == other.precision && this.beforeTolerance == other.beforeTolerance && this.afterTolerance == other.afterTolerance && this.timezoneOffset == other.timezoneOffset && this.calendarModel.equals(other.calendarModel);
    }

    public String toString() {
        return "(Time)" + this.year + "-" + this.month + "-" + this.day + ", " + this.hour + ":" + this.minute + ":" + this.second + "h (-" + this.beforeTolerance + ", +" + this.afterTolerance + ") timezone = " + this.timezoneOffset + " (" + this.calendarModel + ")";
    }
}

