/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;

public abstract class TermedDocumentImpl
implements TermedDocument {
    final Map<String, MonolingualTextValue> labels;
    final Map<String, MonolingualTextValue> descriptions;
    final Map<String, List<MonolingualTextValue>> aliases;

    TermedDocumentImpl(List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases) {
        Validate.notNull(labels, (String)"list of labels cannot be null", (Object[])new Object[0]);
        Validate.notNull(descriptions, (String)"list of descriptions cannot be null", (Object[])new Object[0]);
        Validate.notNull(aliases, (String)"list of aliases cannot be null", (Object[])new Object[0]);
        this.labels = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue label : labels) {
            if (this.labels.containsKey(label.getLanguageCode())) {
                throw new IllegalArgumentException("At most one label allowed per language code");
            }
            this.labels.put(label.getLanguageCode(), label);
        }
        this.descriptions = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue description : descriptions) {
            if (this.descriptions.containsKey(description.getLanguageCode())) {
                throw new IllegalArgumentException("At most one description allowed per language code");
            }
            this.descriptions.put(description.getLanguageCode(), description);
        }
        this.aliases = new HashMap<String, List<MonolingualTextValue>>();
        for (MonolingualTextValue alias : aliases) {
            if (this.aliases.containsKey(alias.getLanguageCode())) {
                this.aliases.get(alias.getLanguageCode()).add(alias);
                continue;
            }
            ArrayList<MonolingualTextValue> aliasesForLanguage = new ArrayList<MonolingualTextValue>();
            aliasesForLanguage.add(alias);
            this.aliases.put(alias.getLanguageCode(), aliasesForLanguage);
        }
    }

    @Override
    public Map<String, MonolingualTextValue> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    @Override
    public Map<String, MonolingualTextValue> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    @Override
    public Map<String, List<MonolingualTextValue>> getAliases() {
        return Collections.unmodifiableMap(this.aliases);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.descriptions.hashCode();
        result = 31 * result + this.labels.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermedDocumentImpl)) {
            return false;
        }
        TermedDocumentImpl other = (TermedDocumentImpl)obj;
        return this.aliases.equals(other.aliases) && this.descriptions.equals(other.descriptions) && this.labels.equals(other.labels);
    }
}

