/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;

public class StatementImpl
implements Statement {
    final Claim claim;
    final List<? extends Reference> references;
    final StatementRank rank;
    final String statementId;

    StatementImpl(Claim claim, List<? extends Reference> references, StatementRank rank, String statementId) {
        Validate.notNull((Object)claim, (String)"Statement main claim cannot be null", (Object[])new Object[0]);
        Validate.notNull(references, (String)"Statement references cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)rank), (String)"Statement ranks cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)statementId, (String)"Statement ids cannot be null", (Object[])new Object[0]);
        this.claim = claim;
        this.references = references;
        this.rank = rank;
        this.statementId = statementId;
    }

    @Override
    public Claim getClaim() {
        return this.claim;
    }

    @Override
    public StatementRank getRank() {
        return this.rank;
    }

    @Override
    public List<? extends Reference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    @Override
    public String getStatementId() {
        return this.statementId;
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 569).append((Object)this.claim).append((Object)this.rank).append(this.references).append((Object)this.statementId).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StatementImpl)) {
            return false;
        }
        StatementImpl other = (StatementImpl)obj;
        return this.claim.equals(other.claim) && this.rank == other.rank && this.references.equals(other.references) && this.statementId.equals(other.statementId);
    }

    public String toString() {
        return "Statement {id = " + this.statementId + ", rank = " + (Object)((Object)this.rank) + ", " + this.references.size() + " references }";
    }
}

