/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

public class StatementGroupImpl
implements StatementGroup {
    final List<Statement> statements;

    public StatementGroupImpl(List<Statement> statements) {
        Validate.notNull(statements, (String)"List of statements cannot be null", (Object[])new Object[0]);
        Validate.notEmpty(statements, (String)"List of statements cannot be empty", (Object[])new Object[0]);
        EntityIdValue subject = statements.get(0).getClaim().getSubject();
        PropertyIdValue property = statements.get(0).getClaim().getMainSnak().getPropertyId();
        for (Statement s : statements) {
            if (!subject.equals(s.getClaim().getSubject())) {
                throw new IllegalArgumentException("All statements in a statement group must use the same subject");
            }
            if (property.equals(s.getClaim().getMainSnak().getPropertyId())) continue;
            throw new IllegalArgumentException("All statements in a statement group must use the same main property");
        }
        this.statements = statements;
    }

    @Override
    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.statements.get(0).getClaim().getMainSnak().getPropertyId();
    }

    @Override
    public EntityIdValue getSubject() {
        return this.statements.get(0).getClaim().getSubject();
    }

    public int hashCode() {
        return this.statements.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StatementGroupImpl)) {
            return false;
        }
        StatementGroupImpl other = (StatementGroupImpl)obj;
        return this.statements.equals(other.statements);
    }

    public String toString() {
        return "[subject: " + this.getSubject() + ", pId: " + this.getProperty() + ", " + this.statements.size() + " items]";
    }
}

