/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;

public class SnakGroupImpl
implements SnakGroup {
    final List<? extends Snak> snaks;

    public SnakGroupImpl(List<? extends Snak> snaks) {
        Validate.notNull(snaks, (String)"List of statements cannot be null", (Object[])new Object[0]);
        Validate.notEmpty(snaks, (String)"List of statements cannot be empty", (Object[])new Object[0]);
        PropertyIdValue property = snaks.get(0).getPropertyId();
        for (Snak snak : snaks) {
            if (property.equals(snak.getPropertyId())) continue;
            throw new IllegalArgumentException("All snaks in a snak group must use the same property");
        }
        this.snaks = snaks;
    }

    @Override
    public List<Snak> getSnaks() {
        return Collections.unmodifiableList(this.snaks);
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.snaks.get(0).getPropertyId();
    }

    public int hashCode() {
        return this.snaks.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SnakGroupImpl)) {
            return false;
        }
        SnakGroupImpl other = (SnakGroupImpl)obj;
        return this.snaks.equals(other.snaks);
    }

    public String toString() {
        return "SnakGroup {pId = " + this.getProperty() + ", " + this.snaks.size() + " snaks}";
    }
}

