/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class QuantityValueImpl
implements QuantityValue {
    final BigDecimal numericValue;
    final BigDecimal lowerBound;
    final BigDecimal upperBound;

    QuantityValueImpl(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound) {
        Validate.notNull((Object)numericValue, (String)"Numeric value cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)lowerBound, (String)"Lower bound cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)upperBound, (String)"Upper bound cannot be null", (Object[])new Object[0]);
        if (lowerBound.compareTo(numericValue) == 1) {
            throw new IllegalArgumentException("Lower bound cannot be strictly greater than numeric value");
        }
        if (numericValue.compareTo(upperBound) == 1) {
            throw new IllegalArgumentException("Upper bound cannot be strictly smaller than numeric value");
        }
        this.numericValue = numericValue;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    @Override
    public BigDecimal getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public BigDecimal getUpperBound() {
        return this.upperBound;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.numericValue.hashCode();
        result = 31 * result + this.lowerBound.hashCode();
        result = 31 * result + this.upperBound.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuantityValueImpl)) {
            return false;
        }
        QuantityValueImpl other = (QuantityValueImpl)obj;
        return this.numericValue.equals(other.numericValue) && this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
    }

    public String toString() {
        return "(Quantity)" + this.lowerBound + " <= " + this.numericValue + " <= " + this.upperBound;
    }
}

