/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class MonolingualTextValueImpl
implements MonolingualTextValue {
    final String text;
    final String languageCode;

    MonolingualTextValueImpl(String text, String languageCode) {
        Validate.notNull((Object)text, (String)"Text cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)languageCode, (String)"Language code cannot be null", (Object[])new Object[0]);
        this.text = text;
        this.languageCode = languageCode;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.languageCode.hashCode();
        result = 31 * result + this.text.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MonolingualTextValueImpl)) {
            return false;
        }
        MonolingualTextValueImpl other = (MonolingualTextValueImpl)obj;
        return this.text.equals(other.text) && this.languageCode.equals(other.languageCode);
    }

    public String toString() {
        return this.text + " (" + this.languageCode + ")";
    }
}

