/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.implementation.TermedDocumentImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

public class ItemDocumentImpl
extends TermedDocumentImpl
implements ItemDocument {
    final ItemIdValue itemId;
    final List<StatementGroup> statementGroups;
    final Map<String, SiteLink> siteLinks;

    ItemDocumentImpl(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks) {
        super(labels, descriptions, aliases);
        Validate.notNull((Object)itemIdValue, (String)"item ID cannot be null", (Object[])new Object[0]);
        Validate.notNull(statementGroups, (String)"statement list cannot be null", (Object[])new Object[0]);
        Validate.notNull(siteLinks, (String)"site links cannot be null", (Object[])new Object[0]);
        if (!statementGroups.isEmpty()) {
            for (StatementGroup sg : statementGroups) {
                if (itemIdValue.equals(sg.getSubject())) continue;
                throw new IllegalArgumentException("All statement groups in a document must have the same subject");
            }
        }
        this.itemId = itemIdValue;
        this.statementGroups = statementGroups;
        this.siteLinks = siteLinks;
    }

    @Override
    public EntityIdValue getEntityId() {
        return this.itemId;
    }

    @Override
    public ItemIdValue getItemId() {
        return this.itemId;
    }

    @Override
    public List<StatementGroup> getStatementGroups() {
        return Collections.unmodifiableList(this.statementGroups);
    }

    @Override
    public Map<String, SiteLink> getSiteLinks() {
        return Collections.unmodifiableMap(this.siteLinks);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.itemId.hashCode();
        result = 31 * result + this.siteLinks.hashCode();
        result = 31 * result + this.statementGroups.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ItemDocumentImpl)) {
            return false;
        }
        ItemDocumentImpl other = (ItemDocumentImpl)obj;
        return this.itemId.equals(other.itemId) && this.siteLinks.equals(other.siteLinks) && this.statementGroups.equals(other.statementGroups);
    }

    public String toString() {
        return "ItemDocument {qId = " + this.itemId + ", " + this.labels.size() + " labels, " + this.descriptions.size() + " descriptions, " + this.aliases.size() + " aliases, " + this.siteLinks.size() + " site links, " + this.statementGroups.size() + " statement groups" + "}";
    }
}

