/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class GlobeCoordinatesValueImpl
implements GlobeCoordinatesValue {
    final long latitude;
    final long longitude;
    final long precision;
    final String globeIri;

    GlobeCoordinatesValueImpl(long latitude, long longitude, long precision, String globeIri) {
        Validate.notNull((Object)globeIri, (String)"globe IRI must not be null", (Object[])new Object[0]);
        if (latitude > 90000000000L || latitude < -90000000000L) {
            throw new IllegalArgumentException("Latitude must be between 90 degrees and -90 degrees.");
        }
        if (longitude > 360000000000L || longitude < -360000000000L) {
            throw new IllegalArgumentException("Longitude must be between -360 degrees and +360 degrees.");
        }
        if (precision != 10000000000L && precision != 1000000000L && precision != 100000000L && precision != 16666667L && precision != 10000000L && precision != 1000000L && precision != 277778L && precision != 100000L && precision != 2777778L && precision != 10000L && precision != 277778L && precision != 1000L && precision != 278L) {
            throw new IllegalArgumentException("Precision must be one of the predefined values.");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.precision = precision;
        this.globeIri = globeIri;
    }

    @Override
    public long getLatitude() {
        return this.latitude;
    }

    @Override
    public long getLongitude() {
        return this.longitude;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public String getGlobe() {
        return this.globeIri;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.globeIri.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.precision);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobeCoordinatesValueImpl)) {
            return false;
        }
        GlobeCoordinatesValueImpl other = (GlobeCoordinatesValueImpl)obj;
        return this.globeIri.equals(other.globeIri) && this.latitude == other.latitude && this.longitude == other.longitude && this.precision == other.precision;
    }

    public String toString() {
        return "(Coordinate)" + this.latitude + "\u00b0N, " + this.longitude + "\u00b0E (\u00b1" + this.precision + ") " + this.globeIri;
    }
}

