/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public abstract class EntityIdValueImpl
implements EntityIdValue {
    final String id;
    final String baseIri;

    EntityIdValueImpl(String id, String baseIri) {
        Validate.notNull((Object)id, (String)"Entity ids cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)baseIri, (String)"Entity base IRIs cannot be null", (Object[])new Object[0]);
        this.id = id;
        this.baseIri = baseIri;
    }

    @Override
    public String getIri() {
        return this.baseIri.concat(this.id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return new HashCodeBuilder(773, 241).append((Object)this.baseIri).append((Object)this.id).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityIdValueImpl)) {
            return false;
        }
        EntityIdValueImpl other = (EntityIdValueImpl)obj;
        return this.id.equals(other.id) && this.baseIri.equals(other.baseIri);
    }
}

