/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;

public class ClaimImpl
implements Claim {
    final EntityIdValue subject;
    final Snak mainSnak;
    final List<SnakGroup> qualifiers;

    ClaimImpl(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        Validate.notNull((Object)subject, (String)"Statement subjects cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)mainSnak, (String)"Statement main Snaks cannot be null", (Object[])new Object[0]);
        Validate.notNull(qualifiers, (String)"Statement qualifier groups cannot be null", (Object[])new Object[0]);
        this.subject = subject;
        this.mainSnak = mainSnak;
        this.qualifiers = qualifiers;
    }

    @Override
    public EntityIdValue getSubject() {
        return this.subject;
    }

    @Override
    public Snak getMainSnak() {
        return this.mainSnak;
    }

    @Override
    public List<SnakGroup> getQualifiers() {
        return Collections.unmodifiableList(this.qualifiers);
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 569).append((Object)this.subject).append((Object)this.mainSnak).append(this.qualifiers).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClaimImpl)) {
            return false;
        }
        ClaimImpl other = (ClaimImpl)obj;
        return this.subject.equals(other.subject) && this.mainSnak.equals(other.mainSnak) && this.qualifiers.equals(other.qualifiers);
    }

    public String toString() {
        return "Claim { main snak = " + this.mainSnak + ", subject = " + this.subject + ", " + this.qualifiers.size() + " qualifiers}";
    }
}

