/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.internal.ObjectPropertiesGetter;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.QueryOrTemplateCall;
import org.topbraid.spin.model.SPINInstance;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.SPINUtil;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPIN;

public class RelevantProperties {
    private static void addProperties(QueryOrTemplateCall qot, Set<Property> results) {
        ElementList where;
        Model model = qot.getCls().getModel();
        if (qot.getTemplateCall() != null) {
            ElementList where2;
            Command spinQuery;
            TemplateCall templateCall = qot.getTemplateCall();
            Template template = templateCall.getTemplate();
            if (template != null && ((spinQuery = template.getBody()) instanceof Ask || spinQuery instanceof Construct) && (where2 = ((Query)spinQuery).getWhere()) != null) {
                ObjectPropertiesGetter getter = new ObjectPropertiesGetter(model, where2, templateCall.getArgumentsMapByProperties());
                getter.run();
                results.addAll(getter.getResults());
            }
        } else if ((qot.getQuery() instanceof Ask || qot.getQuery() instanceof Construct) && (where = qot.getQuery().getWhere()) != null) {
            ObjectPropertiesGetter getter = new ObjectPropertiesGetter(model, where, null);
            getter.run();
            results.addAll(getter.getResults());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Property> getRelevantPropertiesOfClass(Resource cls) {
        HashSet<Property> results = new HashSet<Property>();
        JenaUtil.setGraphReadOptimization(true);
        try {
            StmtIterator it = cls.getModel().listStatements(null, RDFS.domain, (RDFNode)cls);
            while (it.hasNext()) {
                Resource subject = ((Statement)it.next()).getSubject();
                if (!subject.isURIResource()) continue;
                results.add(cls.getModel().getProperty(subject.getURI()));
                JenaUtil.addDomainlessSubProperties(subject, results, new HashSet<Resource>());
            }
            for (Resource superClass : JenaUtil.getSuperClasses(cls)) {
                Statement s = superClass.getProperty(OWL.onProperty);
                if (s == null || !s.getObject().isURIResource()) continue;
                results.add(cls.getModel().getProperty(s.getResource().getURI()));
            }
            Set<Property> others = RelevantProperties.getRelevantSPINPropertiesOfClass(cls);
            if (others != null) {
                for (Property other : others) {
                    results.add(other);
                }
            }
        }
        finally {
            JenaUtil.setGraphReadOptimization(false);
        }
        return results;
    }

    public static Set<Property> getRelevantSPINPropertiesOfInstance(Resource root) {
        if (SP.exists(root.getModel())) {
            SPINInstance instance = (SPINInstance)root.as(SPINInstance.class);
            HashSet<Property> results = new HashSet<Property>();
            for (QueryOrTemplateCall qot : instance.getQueriesAndTemplateCalls(SPIN.constraint)) {
                RelevantProperties.addProperties(qot, results);
            }
            return results;
        }
        return null;
    }

    public static Set<Property> getRelevantSPINPropertiesOfClass(Resource cls) {
        if (SP.exists(cls.getModel())) {
            ArrayList<QueryOrTemplateCall> qots = new ArrayList<QueryOrTemplateCall>();
            SPINUtil.addQueryOrTemplateCalls(cls, SPIN.constraint, qots);
            HashSet<Property> results = new HashSet<Property>();
            for (QueryOrTemplateCall qot : qots) {
                RelevantProperties.addProperties(qot, results);
            }
            return results;
        }
        return null;
    }
}

