/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.spin.arq.AbstractFunction2;
import org.topbraid.spin.util.OptimizedMultiUnion;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class LocalRangeAtClassNativeFunction
extends AbstractFunction2 {
    private static Set<Node> datatypeOrAnnotationProperty = new HashSet<Node>();

    @Override
    protected NodeValue exec(Node cls, Node property, FunctionEnv env) {
        Graph graph = env.getActiveGraph();
        Node result = LocalRangeAtClassNativeFunction.run(cls, property, graph, true);
        return NodeValue.makeNode((Node)result);
    }

    public static Node run(Node cls, Node property, Graph graph, boolean useDefault) {
        Node result = LocalRangeAtClassNativeFunction.walk(property, cls, graph, new HashSet<Node>());
        if (result == null && (result = LocalRangeAtClassNativeFunction.getGlobalRange(property, graph)) == null && useDefault) {
            result = LocalRangeAtClassNativeFunction.getDefaultRange(property, graph);
        }
        return result;
    }

    private static Node getDefaultRange(Node property, Graph graph) {
        if (LocalRangeAtClassNativeFunction.instanceOf(property, datatypeOrAnnotationProperty, graph)) {
            return XSD.xstring.asNode();
        }
        return RDFS.Resource.asNode();
    }

    private static Node getGlobalRange(Node property, Graph graph) {
        return LocalRangeAtClassNativeFunction.getGlobalRangeHelper(property, graph, new HashSet<Node>());
    }

    private static Node getGlobalRangeHelper(Node property, Graph graph, Set<Node> reached) {
        reached.add(property);
        Node range = LocalRangeAtClassNativeFunction.getObject(property, RDFS.range.asNode(), graph);
        if (range != null) {
            return range;
        }
        for (Triple t : graph.find(property, RDFS.subPropertyOf.asNode(), Node.ANY).toList()) {
            Node global;
            Node superProperty = t.getObject();
            if (reached.contains(superProperty) || (global = LocalRangeAtClassNativeFunction.getGlobalRangeHelper(superProperty, graph, reached)) == null) continue;
            return global;
        }
        return null;
    }

    private static Node getObject(Node subject, Node predicate, Graph graph) {
        ExtendedIterator it = graph.find(subject, predicate, Node.ANY);
        if (it.hasNext()) {
            Node object = ((Triple)it.next()).getObject();
            it.close();
            return object;
        }
        return null;
    }

    private static boolean instanceOf(Node instance, Collection<Node> matchTypes, Graph graph) {
        HashSet<Node> reachedTypes = new HashSet<Node>();
        for (Triple t : graph.find(instance, RDF.type.asNode(), Node.ANY).toList()) {
            if (!LocalRangeAtClassNativeFunction.instanceOfHelper(matchTypes, t.getObject(), graph, reachedTypes)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOfHelper(Collection<Node> matchTypes, Node type, Graph graph, Set<Node> reachedTypes) {
        if (reachedTypes.contains(type)) {
            return false;
        }
        if (matchTypes.contains(type)) {
            return true;
        }
        reachedTypes.add(type);
        ExtendedIterator it = graph.find(type, RDFS.subClassOf.asNode(), Node.ANY);
        while (it.hasNext()) {
            Node superClass = ((Triple)it.next()).getObject();
            if (!LocalRangeAtClassNativeFunction.instanceOfHelper(matchTypes, superClass, graph, reachedTypes)) continue;
            it.close();
            return true;
        }
        return false;
    }

    private static Node walk(Node property, Node type, Graph graph, Set<Node> classes) {
        classes.add(type);
        LinkedList<Node> superClasses = new LinkedList<Node>();
        ExtendedIterator it = graph.find(type, RDFS.subClassOf.asNode(), Node.ANY);
        while (it.hasNext()) {
            Node superClass = ((Triple)it.next()).getObject();
            if (superClass.isBlank() && graph.contains(superClass, OWL.onProperty.asNode(), property)) {
                Node allValuesFrom = LocalRangeAtClassNativeFunction.getObject(superClass, OWL.allValuesFrom.asNode(), graph);
                if (allValuesFrom == null) continue;
                it.close();
                return allValuesFrom;
            }
            if (!superClass.isURI()) continue;
            superClasses.add(superClass);
        }
        if (!(graph instanceof OptimizedMultiUnion) || ((OptimizedMultiUnion)graph).getIncludesSPIN()) {
            it = graph.find(type, SPIN.constraint.asNode(), Node.ANY);
            while (it.hasNext()) {
                Node valueType;
                Node constraint = ((Triple)it.next()).getObject();
                if (!graph.contains(constraint, SPL.predicate.asNode(), property) || !graph.contains(constraint, RDF.type.asNode(), SPL.Argument.asNode()) || (valueType = LocalRangeAtClassNativeFunction.getObject(constraint, SPL.valueType.asNode(), graph)) == null) continue;
                it.close();
                return valueType;
            }
        }
        for (Node superClass : superClasses) {
            Node result;
            if (classes.contains(superClass) || (result = LocalRangeAtClassNativeFunction.walk(property, superClass, graph, classes)) == null) continue;
            return result;
        }
        return null;
    }

    static {
        datatypeOrAnnotationProperty.add(OWL.DatatypeProperty.asNode());
        datatypeOrAnnotationProperty.add(OWL.AnnotationProperty.asNode());
    }
}

