/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.spin.vocabulary.ARG;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

class IsMultiFunctionHelper {
    private static Node integerOne = NodeFactory.createLiteral((String)"1", (RDFDatatype)TypeMapper.getInstance().getSafeTypeByName(XSD.integer.getURI()));

    IsMultiFunctionHelper() {
    }

    public static boolean isMulti(Node property, Node type, Graph graph) {
        if (graph.contains(property, RDF.type.asNode(), OWL.FunctionalProperty.asNode())) {
            return false;
        }
        if (type != null) {
            HashSet<Node> reached = new HashSet<Node>();
            return IsMultiFunctionHelper.walk(property, type, graph, reached);
        }
        return true;
    }

    private static boolean hasMaxCardinality(Node restriction, Graph graph, Node predicate) {
        ExtendedIterator it = graph.find(restriction, predicate, Node.ANY);
        if (it.hasNext()) {
            String lex;
            Node object = ((Triple)it.next()).getObject();
            it.close();
            if (object.isLiteral() && ("0".equals(lex = object.getLiteralLexicalForm()) || "1".equals(lex))) {
                return true;
            }
        }
        return false;
    }

    private static boolean walk(Node property, Node type, Graph graph, Set<Node> classes) {
        classes.add(type);
        ExtendedIterator it = graph.find(type, SPIN.constraint.asNode(), Node.ANY);
        while (it.hasNext()) {
            Node constraint = ((Triple)it.next()).getObject();
            if (graph.contains(constraint, SPL.predicate.asNode(), property) && graph.contains(constraint, RDF.type.asNode(), SPL.Argument.asNode())) {
                it.close();
                return false;
            }
            if (!graph.contains(constraint, ARG.property.asNode(), property)) continue;
            if (graph.contains(constraint, RDF.type.asNode(), SPL.ObjectCountPropertyConstraint.asNode()) && graph.contains(constraint, ARG.maxCount.asNode(), integerOne)) {
                it.close();
                return false;
            }
            if (!graph.contains(constraint, RDF.type.asNode(), SPL.PrimaryKeyPropertyConstraint.asNode())) continue;
            it.close();
            return false;
        }
        LinkedList<Node> superClasses = new LinkedList<Node>();
        ExtendedIterator it2 = graph.find(type, RDFS.subClassOf.asNode(), Node.ANY);
        while (it2.hasNext()) {
            Node restriction = ((Triple)it2.next()).getObject();
            if (restriction.isBlank() && graph.contains(restriction, OWL.onProperty.asNode(), property)) {
                if (!IsMultiFunctionHelper.hasMaxCardinality(restriction, graph, OWL.maxCardinality.asNode()) && !IsMultiFunctionHelper.hasMaxCardinality(restriction, graph, OWL.cardinality.asNode())) continue;
                it2.close();
                return false;
            }
            if (!restriction.isURI()) continue;
            superClasses.add(restriction);
        }
        for (Node superClass : superClasses) {
            if (classes.contains(superClass) || IsMultiFunctionHelper.walk(property, superClass, graph, classes)) continue;
            return false;
        }
        return true;
    }
}

