/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;

public class GraphBulkUpdate {
    public static void add(Graph graph, Triple[] triples) {
        for (Triple triple : triples) {
            graph.add(triple);
        }
    }

    public static void add(Graph graph, Iterator<Triple> triples) {
        LinkedList<Triple> list = new LinkedList<Triple>();
        while (triples.hasNext()) {
            list.add(triples.next());
        }
        GraphBulkUpdate.add(graph, list);
    }

    public static void add(Graph graph, List<Triple> triples) {
        for (Triple triple : triples) {
            graph.add(triple);
        }
    }

    public static void addInto(Graph graph, Graph src) {
        GraphBulkUpdate.add(graph, (Iterator<Triple>)src.find(Triple.ANY));
    }

    public static void addInto(Model model, Model src) {
        GraphBulkUpdate.addInto(model.getGraph(), src.getGraph());
    }

    public static void delete(Graph graph, Triple[] triples) {
        for (Triple triple : triples) {
            graph.delete(triple);
        }
    }

    public static void delete(Graph graph, Iterator<Triple> triples) {
        LinkedList<Triple> list = new LinkedList<Triple>();
        while (triples.hasNext()) {
            list.add(triples.next());
        }
        GraphBulkUpdate.delete(graph, list);
    }

    public static void delete(Graph graph, List<Triple> triples) {
        for (Triple triple : triples) {
            graph.delete(triple);
        }
    }

    public static void deleteFrom(Graph graph, Graph src) {
        GraphBulkUpdate.delete(graph, (Iterator<Triple>)src.find(Triple.ANY));
    }
}

