/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.system;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.topbraid.spin.arq.PropertyChainHelperPFunction;
import org.topbraid.spin.arq.SPINARQPFunction;
import org.topbraid.spin.arq.SPINARQPFunctionFactory;
import org.topbraid.spin.arq.SPINFunctionDrivers;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.arq.functions.AskFunction;
import org.topbraid.spin.arq.functions.ConstructPFunction;
import org.topbraid.spin.arq.functions.ConstructViolationsPFunction;
import org.topbraid.spin.arq.functions.EvalFunction;
import org.topbraid.spin.arq.functions.SelectPFunction;
import org.topbraid.spin.arq.functions.ViolatesConstraintsFunction;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.system.ExtraPrefixes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class SPINModuleRegistry {
    private Map<String, Function> functions = new HashMap<String, Function>();
    private Map<Node, Object> sources = new HashMap<Node, Object>();
    private Map<String, Template> templates = new HashMap<String, Template>();
    private static SPINModuleRegistry singleton = new SPINModuleRegistry();

    public static SPINModuleRegistry get() {
        return singleton;
    }

    public static void set(SPINModuleRegistry value) {
        singleton = value;
    }

    public Function getFunction(String uri, Model model) {
        Function function = this.functions.get(uri);
        if (function != null) {
            return function;
        }
        if (model != null && JenaUtil.hasIndirectType(function = (Function)model.getResource(uri).as(Function.class), SPIN.Function.inModel(model))) {
            return function;
        }
        return null;
    }

    public Collection<Function> getFunctions() {
        return this.functions.values();
    }

    public Set<Model> getModels() {
        HashSet<Model> spinModels = new HashSet<Model>();
        for (Function function : SPINModuleRegistry.get().getFunctions()) {
            spinModels.add(function.getModel());
        }
        for (Template template : SPINModuleRegistry.get().getTemplates()) {
            spinModels.add(template.getModel());
        }
        return spinModels;
    }

    public Object getSource(Function function) {
        return this.sources.get(function.asNode());
    }

    public Template getTemplate(String uri, Model model) {
        Resource r;
        if (model != null && JenaUtil.hasIndirectType(r = model.getResource(uri), SPIN.Template.inModel(model))) {
            return (Template)r.as(Template.class);
        }
        return this.templates.get(uri);
    }

    public Collection<Template> getTemplates() {
        return this.templates.values();
    }

    public void init() {
        Model splModel = SPL.getModel();
        Model spinModel = SPIN.getModel();
        MultiUnion multiUnion = JenaUtil.createMultiUnion(new Graph[]{splModel.getGraph(), spinModel.getGraph()});
        multiUnion.setBaseGraph(splModel.getGraph());
        Model unionModel = ModelFactory.createModelForGraph((Graph)multiUnion);
        this.registerAll(unionModel, null);
        FunctionRegistry.get().put(SPIN.ask.getURI(), (FunctionFactory)new AskFunction());
        FunctionRegistry.get().put(SPIN.eval.getURI(), (FunctionFactory)new EvalFunction());
        FunctionRegistry.get().put(SPIN.violatesConstraints.getURI(), (FunctionFactory)new ViolatesConstraintsFunction());
        PropertyFunctionRegistry.get().put(SPIN.construct.getURI(), ConstructPFunction.class);
        PropertyFunctionRegistry.get().put(SPIN.constructViolations.getURI(), ConstructViolationsPFunction.class);
        PropertyFunctionRegistry.get().put(SPIN.select.getURI(), SelectPFunction.class);
        PropertyFunctionRegistry.get().put("http://topbraid.org/spin/owlrl#propertyChainHelper", PropertyChainHelperPFunction.class);
    }

    public void register(Function function, Object source, boolean addARQFunction) {
        this.functions.put(function.getURI(), function);
        if (source != null) {
            this.sources.put(function.asNode(), source);
        }
        ExtraPrefixes.add(function);
        if (addARQFunction) {
            this.registerARQFunction(function);
            if (function.isMagicProperty()) {
                this.registerARQPFunction(function);
            }
        }
    }

    public void register(Template template) {
        this.templates.put(template.getURI(), template);
    }

    public void registerAll(Model model, Object source) {
        this.registerFunctions(model, source);
        this.registerTemplates(model);
    }

    protected void registerARQFunction(Function spinFunction) {
        SPINFunctionFactory newFF;
        FunctionFactory oldFF = FunctionRegistry.get().get(spinFunction.getURI());
        if ((oldFF == null || oldFF instanceof SPINFunctionFactory) && (newFF = SPINFunctionDrivers.get().create(spinFunction)) != null) {
            FunctionRegistry.get().put(spinFunction.getURI(), (FunctionFactory)newFF);
        }
    }

    public void registerARQPFunction(Function function) {
        PropertyFunctionFactory old;
        if (function.hasProperty(SPIN.body) && ((old = PropertyFunctionRegistry.get().get(function.getURI())) == null || old instanceof SPINARQPFunction)) {
            SPINARQPFunction arqFunction = SPINARQPFunctionFactory.get().create(function);
            PropertyFunctionRegistry.get().put(function.getURI(), (PropertyFunctionFactory)arqFunction);
        }
    }

    public void registerFunctions(Model model, Object source) {
        for (Resource resource : JenaUtil.getAllInstances(SPIN.Function.inModel(model))) {
            Function function = SPINFactory.asFunction(resource);
            this.register(function, source, true);
        }
    }

    public void registerTemplates(Model model) {
        for (Resource resource : JenaUtil.getAllInstances(SPIN.Template.inModel(model))) {
            if (!resource.isURIResource()) continue;
            Template template = (Template)resource.as(Template.class);
            this.register(template);
            ExtraPrefixes.add(template);
        }
    }

    public void reset() {
        this.functions.clear();
        this.sources.clear();
        this.templates.clear();
    }
}

