/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.system;

import java.util.Map;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.util.JenaUtil;

public class SPINLabels {
    private static SPINLabels singleton = new SPINLabels();

    public static SPINLabels get() {
        return singleton;
    }

    public static void set(SPINLabels value) {
        singleton = value;
    }

    public String getCustomizedLabel(Resource resource) {
        String label = JenaUtil.getStringProperty(resource, RDFS.label);
        if (label != null) {
            return label;
        }
        return this.getLabel(resource);
    }

    public String getLabel(Resource resource) {
        if (resource.isURIResource() && resource.getModel() != null) {
            String qname = resource.getModel().qnameFor(resource.getURI());
            if (qname != null) {
                return qname;
            }
            return "<" + resource.getURI() + ">";
        }
        return resource.toString();
    }

    public static void appendTemplateCallLabel(StringBuffer buffer, String labelTemplate, Map<String, RDFNode> args) {
        for (int i = 0; i < labelTemplate.length(); ++i) {
            if (i < labelTemplate.length() - 3 && labelTemplate.charAt(i) == '{' && labelTemplate.charAt(i + 1) == '?') {
                int varEnd;
                for (varEnd = i + 2; varEnd < labelTemplate.length(); ++varEnd) {
                    if (labelTemplate.charAt(varEnd) != '}') continue;
                    String varName = labelTemplate.substring(i + 2, varEnd);
                    RDFNode varValue = args.get(varName);
                    if (varValue instanceof Resource) {
                        buffer.append(SPINLabels.get().getLabel((Resource)varValue));
                        break;
                    }
                    if (!(varValue instanceof Literal)) break;
                    buffer.append(varValue.asNode().getLiteralLexicalForm());
                    break;
                }
                i = varEnd;
                continue;
            }
            buffer.append(labelTemplate.charAt(i));
        }
    }
}

