/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.progress;

import org.topbraid.spin.progress.ProgressMonitor;

public class SimpleProgressMonitor
implements ProgressMonitor {
    private String name;
    private int currentWork;
    private int totalWork;

    public SimpleProgressMonitor(String name) {
        this.name = name;
    }

    @Override
    public void beginTask(String label, int totalWork) {
        this.println("Beginning task " + label + " (" + totalWork + ")");
        this.totalWork = totalWork;
        this.currentWork = 0;
    }

    @Override
    public void done() {
        this.println("Done");
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    protected void println(String text) {
        System.out.println(this.name + ": " + text);
    }

    @Override
    public void setCanceled(boolean value) {
    }

    @Override
    public void setTaskName(String value) {
        this.println("Task name: " + value);
    }

    @Override
    public void subTask(String label) {
        this.println("Subtask: " + label);
    }

    @Override
    public void worked(int amount) {
        this.currentWork += amount;
        this.println("Worked " + this.currentWork + " / " + this.totalWork);
    }
}

