/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.print;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.NodeToLabelMap;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.system.ExtraPrefixes;

public class StringPrintContext
implements PrintContext {
    private static final PrefixMapping noPrefixMapping = new PrefixMappingImpl();
    private int indentation;
    private Map<String, RDFNode> initialBindings;
    protected String indentationString = "    ";
    private boolean namedBNodeMode;
    private boolean nested;
    private NodeToLabelMap nodeToLabelMap;
    private boolean printPrefixes;
    private StringBuilder sb;
    private boolean useExtraPrefixes;
    private boolean usePrefixes = true;

    public StringPrintContext() {
        this(new StringBuilder());
    }

    public StringPrintContext(StringBuilder sb) {
        this(sb, new HashMap<String, RDFNode>());
    }

    public StringPrintContext(StringBuilder sb, Map<String, RDFNode> initialBindings) {
        this.sb = sb;
        this.initialBindings = initialBindings;
    }

    @Override
    public PrintContext clone() {
        StringPrintContext cl = new StringPrintContext(this.sb);
        cl.setIndentation(this.getIndentation());
        cl.setNested(this.isNested());
        cl.setUseExtraPrefixes(this.getUseExtraPrefixes());
        cl.setUsePrefixes(this.getUsePrefixes());
        cl.initialBindings = this.initialBindings;
        cl.sb = this.sb;
        return cl;
    }

    @Override
    public int getIndentation() {
        return this.indentation;
    }

    @Override
    public RDFNode getInitialBinding(String varName) {
        return this.initialBindings.get(varName);
    }

    @Override
    public NodeToLabelMap getNodeToLabelMap() {
        if (this.nodeToLabelMap == null) {
            this.nodeToLabelMap = new NodeToLabelMap();
        }
        return this.nodeToLabelMap;
    }

    @Override
    public boolean getPrintPrefixes() {
        return this.printPrefixes;
    }

    public String getString() {
        return this.sb.toString();
    }

    public StringBuilder getStringBuilder() {
        return this.sb;
    }

    @Override
    public boolean getUseExtraPrefixes() {
        return this.useExtraPrefixes;
    }

    @Override
    public boolean getUsePrefixes() {
        return this.usePrefixes;
    }

    @Override
    public boolean hasInitialBindings() {
        return this.initialBindings != null && !this.initialBindings.isEmpty();
    }

    @Override
    public boolean isNamedBNodeMode() {
        return this.namedBNodeMode;
    }

    @Override
    public boolean isNested() {
        return this.nested;
    }

    @Override
    public void print(String str) {
        this.sb.append(str.toString());
    }

    @Override
    public void printIndentation(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.print(this.indentationString);
        }
    }

    @Override
    public void printKeyword(String str) {
        this.print(str);
    }

    @Override
    public void println() {
        this.print("\n");
    }

    @Override
    public void printVariable(String str) {
        RDFNode binding = this.getInitialBinding(str);
        if (binding == null || binding.isAnon()) {
            this.print("?" + str);
        } else if (binding.isURIResource()) {
            this.printURIResource((Resource)binding);
        } else {
            String lit = FmtUtils.stringForNode((Node)binding.asNode(), (PrefixMapping)noPrefixMapping);
            this.print(lit);
        }
    }

    @Override
    public void printURIResource(Resource resource) {
        if (this.getUsePrefixes()) {
            String qname = StringPrintContext.qnameFor(resource);
            if (qname != null) {
                this.print(qname);
                return;
            }
            if (this.getUseExtraPrefixes()) {
                Map<String, String> extras = ExtraPrefixes.getExtraPrefixes();
                for (String prefix : extras.keySet()) {
                    String ns = extras.get(prefix);
                    if (!resource.getURI().startsWith(ns)) continue;
                    this.print(prefix);
                    this.print(":");
                    this.print(resource.getURI().substring(ns.length()));
                    return;
                }
            }
        }
        this.print("<");
        this.print(resource.getURI());
        this.print(">");
    }

    public static String qnameFor(Resource resource) {
        Graph graph = resource.getModel().getGraph();
        if (graph instanceof MultiUnion) {
            String prefix;
            int split;
            String uri = resource.getURI();
            String local = uri.substring(split = Util.splitNamespaceXML((String)uri));
            if (local.length() == 0) {
                return null;
            }
            String ns = uri.substring(0, split);
            MultiUnion mu = (MultiUnion)graph;
            Graph baseGraph = mu.getBaseGraph();
            if (baseGraph != null && (prefix = baseGraph.getPrefixMapping().getNsURIPrefix(ns)) != null) {
                return prefix + ":" + local;
            }
            List graphs = mu.getSubGraphs();
            for (int i = 0; i < graphs.size(); ++i) {
                Graph subGraph = (Graph)graphs.get(i);
                String prefix2 = subGraph.getPrefixMapping().getNsURIPrefix(ns);
                if (prefix2 == null || prefix2.length() <= 0) continue;
                return prefix2 + ":" + local;
            }
            return null;
        }
        return resource.getModel().qnameFor(resource.getURI());
    }

    @Override
    public void setIndentation(int value) {
        this.indentation = value;
    }

    public void setIndentationString(String value) {
        this.indentationString = value;
    }

    @Override
    public void setNamedBNodeMode(boolean value) {
        this.namedBNodeMode = value;
    }

    @Override
    public void setNested(boolean value) {
        this.nested = value;
    }

    @Override
    public void setPrintPrefixes(boolean value) {
        this.printPrefixes = value;
    }

    @Override
    public void setUseExtraPrefixes(boolean value) {
        this.useExtraPrefixes = value;
    }

    @Override
    public void setUsePrefixes(boolean value) {
        this.usePrefixes = value;
    }
}

