/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.TupleImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.StringPrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;

public class ElementListImpl
extends RDFListImpl
implements ElementList {
    public ElementListImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    private int addListMembers(List<Element> elements, int i, List<RDFNode> members) {
        boolean first = true;
        while (i < elements.size() - 1 && elements.get(i) instanceof TriplePattern && elements.get(i + 1) instanceof TriplePattern) {
            TriplePattern firstPattern = (TriplePattern)elements.get(i);
            TriplePattern secondPattern = (TriplePattern)elements.get(i + 1);
            if (RDF.first.equals(firstPattern.getPredicate()) && RDF.rest.equals(secondPattern.getPredicate())) {
                Resource firstSubject = firstPattern.getSubject();
                Resource secondSubject = secondPattern.getSubject();
                if (firstSubject instanceof Variable && secondSubject instanceof Variable) {
                    Variable firstVar = (Variable)firstSubject;
                    Variable secondVar = (Variable)secondSubject;
                    if (firstVar.isBlankNodeVar() && firstVar.getName().equals(secondVar.getName())) {
                        members.add(firstPattern.getObject());
                        RDFNode secondObject = secondPattern.getObject();
                        ++i;
                        if (RDF.nil.equals((Object)secondObject)) {
                            return i + 1;
                        }
                    }
                }
            }
            if (first && members.isEmpty()) break;
            first = false;
            ++i;
        }
        return i;
    }

    @Override
    public List<Element> getElements() {
        LinkedList<Element> results = new LinkedList<Element>();
        ExtendedIterator it = this.iterator();
        while (it.hasNext()) {
            Element element;
            RDFNode node = (RDFNode)it.next();
            if (!node.isResource() || (element = SPINFactory.asElement((Resource)node)) == null) continue;
            results.add(element);
        }
        return results;
    }

    private boolean nextIsMatchingVarPattern(TriplePattern main, List<Element> elements, int i) {
        Variable mainVar;
        if (main.getObject() instanceof Variable && i < elements.size() - 2 && elements.get(i + 1) instanceof TriplePattern && elements.get(i + 2) instanceof TriplePattern && (mainVar = (Variable)main.getObject()).isBlankNodeVar()) {
            TriplePattern nextPattern = (TriplePattern)elements.get(i + 1);
            TriplePattern lastPattern = (TriplePattern)elements.get(i + 2);
            Resource nextSubject = nextPattern.getSubject();
            Resource lastSubject = lastPattern.getSubject();
            if (nextSubject instanceof Variable && lastSubject instanceof Variable && RDF.first.equals(nextPattern.getPredicate()) && RDF.rest.equals(lastPattern.getPredicate())) {
                Variable nextVar = (Variable)nextSubject;
                if (mainVar.getName().equals(nextVar.getName())) {
                    Variable lastVar = (Variable)lastSubject;
                    return mainVar.getName().equals(lastVar.getName());
                }
            }
        }
        return false;
    }

    @Override
    public void print(PrintContext p) {
        List<Element> elements = this.getElements();
        int oldI = -1;
        for (int i = 0; i < elements.size() && i != oldI; ++i) {
            oldI = i;
            Element element = elements.get(i);
            p.printIndentation(p.getIndentation());
            if (element instanceof ElementList) {
                p.print("{");
                p.println();
                p.setIndentation(p.getIndentation() + 1);
                element.print(p);
                p.setIndentation(p.getIndentation() - 1);
                p.printIndentation(p.getIndentation());
                p.print("}");
            } else if (element instanceof TriplePattern) {
                i = this.printTriplePattern(elements, i, p);
            } else {
                element.print(p);
            }
            p.print(" .");
            p.println();
        }
    }

    private int printTriplePattern(List<Element> elements, int i, PrintContext p) {
        TriplePattern main = (TriplePattern)elements.get(i);
        ArrayList<RDFNode> leftList = new ArrayList<RDFNode>();
        i = this.addListMembers(elements, i, leftList);
        if (leftList.isEmpty()) {
            TupleImpl.print(this.getModel(), (RDFNode)main.getSubject(), p);
        } else {
            this.printRDFList(p, leftList);
            main = (TriplePattern)elements.get(i);
        }
        p.print(" ");
        if (RDF.type.equals(main.getPredicate())) {
            p.print("a");
        } else {
            TupleImpl.print(this.getModel(), (RDFNode)main.getPredicate(), p);
        }
        p.print(" ");
        if (this.nextIsMatchingVarPattern(main, elements, i)) {
            ArrayList<RDFNode> rightList = new ArrayList<RDFNode>();
            i = this.addListMembers(elements, i + 1, rightList);
            if (rightList.isEmpty()) {
                TupleImpl.print(this.getModel(), main.getObject(), p);
                if (!leftList.isEmpty()) {
                    --i;
                }
            } else {
                this.printRDFList(p, rightList);
                --i;
            }
        } else {
            TupleImpl.print(this.getModel(), main.getObject(), p);
        }
        return i;
    }

    private void printRDFList(PrintContext p, List<RDFNode> members) {
        p.print("(");
        for (RDFNode node : members) {
            p.print(" ");
            TupleImpl.print(this.getModel(), node, p);
        }
        p.print(" )");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringPrintContext context = new StringPrintContext(sb);
        this.print(context);
        return sb.toString();
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

