/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.TripleTemplate;
import org.topbraid.spin.model.impl.QueryImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.vocabulary.SP;

public class ConstructImpl
extends QueryImpl
implements Construct {
    public ConstructImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public List<TripleTemplate> getTemplates() {
        LinkedList<TripleTemplate> results = new LinkedList<TripleTemplate>();
        for (RDFNode next : this.getList(SP.templates)) {
            if (next == null || !next.isResource()) continue;
            results.add((TripleTemplate)next.as(TripleTemplate.class));
        }
        return results;
    }

    @Override
    public void printSPINRDF(PrintContext context) {
        this.printComment(context);
        this.printPrefixes(context);
        context.printIndentation(context.getIndentation());
        context.printKeyword("CONSTRUCT");
        context.print(" {");
        context.println();
        for (TripleTemplate template : this.getTemplates()) {
            context.printIndentation(context.getIndentation() + 1);
            template.print(context);
            context.print(" .");
            context.println();
        }
        context.printIndentation(context.getIndentation());
        context.print("}");
        this.printStringFrom(context);
        context.println();
        this.printWhere(context);
        this.printSolutionModifiers(context);
        this.printValues(context);
    }
}

