/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.impl.AbstractAttributeImpl;
import org.topbraid.spin.vocabulary.SP;
import org.topbraid.spin.vocabulary.SPL;

public class ArgumentImpl
extends AbstractAttributeImpl
implements Argument {
    public ArgumentImpl(Node node, EnhGraph eg) {
        super(node, eg);
    }

    @Override
    public Integer getArgIndex() {
        String varName = this.getVarName();
        if (varName != null) {
            return SP.getArgPropertyIndex(varName);
        }
        return null;
    }

    @Override
    public RDFNode getDefaultValue() {
        Statement s = this.getProperty(SPL.defaultValue);
        if (s != null) {
            return s.getObject();
        }
        return null;
    }

    @Override
    public String getVarName() {
        Property argProperty = this.getPredicate();
        if (argProperty != null) {
            return argProperty.getLocalName();
        }
        return null;
    }

    @Override
    public boolean isOptional() {
        Statement s = this.getProperty(SPL.optional);
        if (s != null && s.getObject().isLiteral()) {
            return s.getBoolean();
        }
        return false;
    }
}

