/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.SPINResourceImpl;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.Printable;
import org.topbraid.spin.model.print.StringPrintContext;
import org.topbraid.spin.system.ExtraPrefixes;
import org.topbraid.spin.util.SPINExpressions;
import org.topbraid.spin.util.SPINUtil;
import org.topbraid.spin.vocabulary.SP;

public abstract class AbstractSPINResourceImpl
extends SPINResourceImpl
implements Printable {
    public static final String INDENTATION = " ";

    public AbstractSPINResourceImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    public String getComment() {
        return this.getString(RDFS.comment);
    }

    public List<Element> getElements() {
        return this.getElements(SP.elements);
    }

    public List<Element> getElements(Property predicate) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (RDFNode node : this.getList(predicate)) {
            if (node == null || !node.isResource()) continue;
            results.add(SPINFactory.asElement((Resource)node));
        }
        return results;
    }

    public List<RDFNode> getList(Property predicate) {
        Resource rawList = this.getResource(predicate);
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        if (rawList != null) {
            RDFList list = (RDFList)rawList.as(RDFList.class);
            for (RDFNode node : list) {
                results.add(node);
            }
        }
        return results;
    }

    private String getPrefix(String namespace, PrintContext context) {
        String prefix = this.getModel().getNsURIPrefix(namespace);
        if (prefix == null && context.getUseExtraPrefixes()) {
            Map<String, String> extras = ExtraPrefixes.getExtraPrefixes();
            for (String extraPrefix : extras.keySet()) {
                String ns = extras.get(extraPrefix);
                if (!namespace.equals(ns)) continue;
                return extraPrefix;
            }
        }
        return prefix;
    }

    public static boolean hasRDFType(Node node, EnhGraph graph, Resource type) {
        return graph.asGraph().contains(node, RDF.type.asNode(), type.asNode());
    }

    protected void printComment(PrintContext context) {
        String str = this.getComment();
        if (str != null) {
            String[] rows = str.split("\n");
            for (int i = 0; i < rows.length; ++i) {
                context.print("# ");
                context.print(rows[i]);
                context.println();
            }
        }
    }

    protected void printNestedElementList(PrintContext p) {
        this.printNestedElementList(p, SP.elements);
    }

    protected void printNestedElementList(PrintContext p, Property predicate) {
        p.print(" {");
        p.println();
        Resource elementsRaw = this.getResource(predicate);
        if (elementsRaw != null) {
            ElementList elements = (ElementList)elementsRaw.as(ElementList.class);
            p.setIndentation(p.getIndentation() + 1);
            elements.print(p);
            p.setIndentation(p.getIndentation() - 1);
        }
        p.printIndentation(p.getIndentation());
        p.print("}");
    }

    protected void printNestedExpressionString(PrintContext context, RDFNode node) {
        this.printNestedExpressionString(context, node, false);
    }

    protected void printNestedExpressionString(PrintContext p, RDFNode node, boolean force) {
        SPINExpressions.printExpressionString(p, node, true, force, this.getModel().getGraph().getPrefixMapping());
    }

    protected void printPrefixes(PrintContext context) {
        if (context.getPrintPrefixes()) {
            Set<Resource> uriResources = SPINUtil.getURIResources(this);
            HashSet<String> namespaces = new HashSet<String>();
            for (Resource resource : uriResources) {
                String namespace = resource.getNameSpace();
                namespaces.add(namespace);
            }
            HashMap<String, String> prefix2Namespace = new HashMap<String, String>();
            for (String namespace : namespaces) {
                String prefix = this.getPrefix(namespace, context);
                if (prefix == null) continue;
                prefix2Namespace.put(prefix, namespace);
            }
            ArrayList arrayList = new ArrayList(prefix2Namespace.keySet());
            Collections.sort(arrayList);
            for (String prefix : arrayList) {
                context.printKeyword("PREFIX");
                context.print(INDENTATION);
                context.print(prefix);
                context.print(": <");
                String ns = (String)prefix2Namespace.get(prefix);
                context.print(ns);
                context.print(">");
                context.println();
            }
        }
    }

    public String toString() {
        StringPrintContext p = new StringPrintContext();
        this.print(p);
        return p.getString();
    }

    public static void printVarOrResource(PrintContext p, Resource resource) {
        Variable variable = SPINFactory.asVariable((RDFNode)resource);
        if (variable != null) {
            variable.print(p);
        } else if (resource.isURIResource()) {
            p.printURIResource(resource);
        } else if (p.isNamedBNodeMode()) {
            p.print(p.getNodeToLabelMap().asString(resource.asNode()));
        } else {
            p.print("[]");
        }
    }
}

