/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.topbraid.spin.inference.ControlledUpdateGraph;

class ControlledUpdateGraphStore
implements DatasetGraph {
    private Map<Graph, ControlledUpdateGraph> cugs = new HashMap<Graph, ControlledUpdateGraph>();
    private Dataset dataset;

    ControlledUpdateGraphStore(Dataset dataset, Iterable<Graph> controlledGraphs) {
        this.dataset = dataset;
        for (Graph graph : controlledGraphs) {
            ControlledUpdateGraph cug = new ControlledUpdateGraph(graph);
            this.cugs.put(graph, cug);
        }
    }

    public void clear() {
    }

    private Graph getControlledUpdateGraph(Graph graph) {
        Graph cug = (Graph)this.cugs.get(graph);
        if (cug != null) {
            return cug;
        }
        return graph;
    }

    public Iterable<ControlledUpdateGraph> getControlledUpdateGraphs() {
        return this.cugs.values();
    }

    public Graph getDefaultGraph() {
        Model defaultModel = this.dataset.getDefaultModel();
        if (defaultModel != null) {
            return this.getControlledUpdateGraph(defaultModel.getGraph());
        }
        return null;
    }

    public Graph getGraph(Node graphNode) {
        Model model = this.dataset.getNamedModel(graphNode.getURI());
        if (model != null) {
            return this.getControlledUpdateGraph(model.getGraph());
        }
        return null;
    }

    public boolean containsGraph(Node graphNode) {
        return this.dataset.containsNamedModel(graphNode.getURI());
    }

    public void setDefaultGraph(Graph g) {
    }

    public void addGraph(Node graphName, Graph graph) {
    }

    public void removeGraph(Node graphName) {
    }

    public Iterator<Node> listGraphNodes() {
        LinkedList<Node> results = new LinkedList<Node>();
        Iterator it = this.dataset.listNames();
        while (it.hasNext()) {
            results.add(NodeFactory.createURI((String)((String)it.next())));
        }
        return results.iterator();
    }

    public void add(Quad quad) {
        Graph graph = quad.isDefaultGraph() ? this.getDefaultGraph() : this.getGraph(quad.getGraph());
        if (graph != null) {
            graph.add(quad.asTriple());
        }
    }

    public void delete(Quad quad) {
        Graph graph = quad.isDefaultGraph() ? this.getDefaultGraph() : this.getGraph(quad.getGraph());
        if (graph != null) {
            graph.delete(quad.asTriple());
        }
    }

    public void deleteAny(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        List list = Iter.toList(iter);
        for (Quad q : list) {
            this.delete(q);
        }
    }

    public Iterator<Quad> find() {
        return null;
    }

    public Iterator<Quad> find(Quad quad) {
        return null;
    }

    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return null;
    }

    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return null;
    }

    public boolean contains(Node g, Node s, Node p, Node o) {
        Graph graph = this.getGraph(g);
        if (graph != null) {
            return graph.contains(s, p, o);
        }
        return false;
    }

    public boolean contains(Quad quad) {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public Lock getLock() {
        return null;
    }

    public Context getContext() {
        return ARQ.getContext();
    }

    public long size() {
        return 0L;
    }

    public void close() {
    }

    public void add(Node g, Node s, Node p, Node o) {
        this.add(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
    }

    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(Quad.create((Node)g, (Node)s, (Node)p, (Node)o));
    }
}

