/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

class ControlledUpdateGraph
implements GraphWithPerform {
    private Graph delegate;
    private Set<Triple> addedTriples = new HashSet<Triple>();
    private Set<Triple> deletedTriples = new HashSet<Triple>();

    ControlledUpdateGraph(Graph delegate) {
        this.delegate = delegate;
    }

    public void add(Triple t) throws AddDeniedException {
        this.performAdd(t);
    }

    public void clear() {
        for (Triple triple : this.find(Node.ANY, Node.ANY, Node.ANY).toList()) {
            this.delete(triple);
        }
    }

    public boolean dependsOn(Graph other) {
        return this.delegate.dependsOn(other);
    }

    public TransactionHandler getTransactionHandler() {
        return this.delegate.getTransactionHandler();
    }

    public Capabilities getCapabilities() {
        return this.delegate.getCapabilities();
    }

    public GraphEventManager getEventManager() {
        return this.delegate.getEventManager();
    }

    public GraphStatisticsHandler getStatisticsHandler() {
        return this.delegate.getStatisticsHandler();
    }

    public PrefixMapping getPrefixMapping() {
        return this.delegate.getPrefixMapping();
    }

    public void delete(Triple t) throws DeleteDeniedException {
        this.performDelete(t);
    }

    public ExtendedIterator<Triple> find(Triple m) {
        return this.delegate.find(m);
    }

    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return this.delegate.find(s, p, o);
    }

    public boolean isIsomorphicWith(Graph g) {
        return this.delegate.isIsomorphicWith(g);
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.delegate.contains(s, p, o);
    }

    public boolean contains(Triple t) {
        return this.delegate.contains(t);
    }

    public void close() {
        this.delegate.close();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void performAdd(Triple t) {
        if (!this.delegate.contains(t)) {
            this.addedTriples.add(t);
        }
        this.delegate.add(t);
    }

    public void performDelete(Triple t) {
        if (this.delegate.contains(t)) {
            this.deletedTriples.add(t);
        }
        this.delegate.delete(t);
    }

    public void remove(Node s, Node p, Node o) {
        for (Triple triple : this.find(s, p, o).toList()) {
            this.delete(triple);
        }
    }

    public Iterable<Triple> getAddedTriples() {
        return this.addedTriples;
    }

    public boolean isChanged() {
        return !this.addedTriples.isEmpty() || !this.deletedTriples.isEmpty();
    }
}

