/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.constraints;

import java.util.Collection;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.constraints.SimplePropertyPath;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.vocabulary.SPIN;

public class ConstraintViolation {
    private Collection<TemplateCall> fixes;
    private Resource level;
    private String message;
    private Collection<SimplePropertyPath> paths;
    private Resource root;
    private Resource source;
    private RDFNode value;

    public ConstraintViolation(Resource root, Collection<SimplePropertyPath> paths, Collection<TemplateCall> fixes, String message, Resource source) {
        this.fixes = fixes;
        this.message = message;
        this.root = root;
        this.paths = paths;
        this.source = source;
    }

    public Collection<TemplateCall> getFixes() {
        return this.fixes;
    }

    public Resource getLevel() {
        return this.level == null ? SPIN.Error : this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Collection<SimplePropertyPath> getPaths() {
        return this.paths;
    }

    public Resource getRoot() {
        return this.root;
    }

    public Resource getSource() {
        return this.source;
    }

    public RDFNode getValue() {
        return this.value;
    }

    public boolean isError() {
        return SPIN.Error.equals((Object)this.getLevel()) || SPIN.Fatal.equals((Object)this.getLevel());
    }

    public void setLevel(Resource level) {
        this.level = level;
    }

    public void setValue(RDFNode value) {
        this.value = value;
    }
}

