/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.FmtUtils;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.AbstractFunction;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class InvokeFunction
extends AbstractFunction {
    @Override
    protected NodeValue exec(Node[] nodes, FunctionEnv env) {
        Statement symbolS;
        if (nodes.length == 0) {
            throw new ExprEvalException("Missing function URI argument");
        }
        Node commandNode = nodes[0];
        if (!commandNode.isURI()) {
            throw new ExprEvalException("First argument must be the URI of a function");
        }
        String uri = commandNode.getURI();
        Resource functionResource = SPL.getModel().getResource(uri);
        if ("http://spinrdf.org/sp#".equals(functionResource.getNameSpace()) && (symbolS = functionResource.getProperty(SPIN.symbol)) != null) {
            String varName = "result";
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ?result \n");
            sb.append("WHERE {\n");
            sb.append("    BIND (");
            sb.append(FmtUtils.stringForNode((Node)nodes[1], (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
            sb.append(" ");
            sb.append(symbolS.getString());
            sb.append(" ");
            sb.append(FmtUtils.stringForNode((Node)nodes[2], (PrefixMapping)env.getActiveGraph().getPrefixMapping()));
            sb.append(" AS ?result) . \n");
            sb.append("}");
            Model model = ModelFactory.createModelForGraph((Graph)env.getActiveGraph());
            Query arq = ARQFactory.get().createQuery(model, sb.toString());
            QueryExecution qexec = ARQFactory.get().createQueryExecution(arq, model);
            ResultSet rs = qexec.execSelect();
            try {
                RDFNode result;
                if (rs.hasNext() && (result = rs.next().get("result")) != null) {
                    NodeValue nodeValue = NodeValue.makeNode((Node)result.asNode());
                    return nodeValue;
                }
                throw new ExprEvalException("Failed to evaluate function - empty result set");
            }
            finally {
                qexec.close();
            }
        }
        FunctionFactory ff = FunctionRegistry.get().get(uri);
        if (ff == null) {
            throw new ExprEvalException("Unknown function " + uri);
        }
        Function function = ff.create(uri);
        ExprList exprList = new ExprList();
        for (int i = 1; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node != null) {
                exprList.add((Expr)NodeValue.makeNode((Node)node));
                continue;
            }
            exprList.add(null);
        }
        NodeValue result = function.exec((Binding)new BindingHashMap(), exprList, uri, env);
        return result;
    }
}

