/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq.functions;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.AbstractFunction;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.functions.SPINFunctionUtil;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TemplateCall;

public class AskFunction
extends AbstractFunction
implements FunctionFactory {
    public Function create(String uri) {
        return this;
    }

    @Override
    protected NodeValue exec(Node[] nodes, FunctionEnv env) {
        Query spinQuery;
        if (nodes.length == 0) {
            throw new ExprEvalException("Missing arguments");
        }
        Model model = ModelFactory.createModelForGraph((Graph)env.getActiveGraph());
        QuerySolutionMap initialBinding = SPINFunctionUtil.getInitialBinding(nodes, model);
        Resource queryOrTemplateCall = model.asRDFNode(nodes[0]).asResource();
        if (SPINFactory.isTemplateCall((RDFNode)queryOrTemplateCall)) {
            TemplateCall templateCall = SPINFactory.asTemplateCall((RDFNode)queryOrTemplateCall);
            spinQuery = SPINFactory.asQuery(templateCall.getTemplate().getBody());
            SPINFunctionUtil.addBindingsFromTemplateCall(initialBinding, templateCall);
        } else {
            spinQuery = SPINFactory.asQuery(queryOrTemplateCall);
        }
        DatasetWithDifferentDefaultModel dataset = new DatasetWithDifferentDefaultModel(model, DatasetImpl.wrap((DatasetGraph)env.getDataset()));
        org.apache.jena.query.Query arqQuery = ARQFactory.get().createQuery(spinQuery);
        QueryExecution qexec = ARQFactory.get().createQueryExecution(arqQuery, dataset, (QuerySolution)initialBinding);
        boolean result = qexec.execAsk();
        qexec.close();
        return NodeValue.makeBoolean((boolean)result);
    }
}

