/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.PFunctionQueryIterator;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.system.MagicPropertyPolicy;
import org.topbraid.spin.util.JenaUtil;

public class SPINARQPFunction
extends PropertyFunctionBase
implements PropertyFunctionFactory {
    public static final String SELECT_STAR_NOT_SUPPORTED_IN_MAGIC_PROPERTIES = "SELECT * not supported in magic properties";
    public static final String SELECT_WITH_EXPRESSIONS_NOT_SUPPORTED_IN_MAGIC_PROPERTIES = "SELECT with expressions not supported in magic properties";
    private Query arqQuery;
    private String queryString;
    private List<String> objectVarNames = new ArrayList<String>();

    public SPINARQPFunction(Function functionCls) {
        Select spinQuery = (Select)functionCls.getBody();
        this.queryString = ARQFactory.get().createCommandString(spinQuery);
        List<String> resultVariables = spinQuery.getResultVariableNames();
        if (resultVariables.isEmpty()) {
            throw new IllegalArgumentException(SELECT_STAR_NOT_SUPPORTED_IN_MAGIC_PROPERTIES);
        }
        for (String varName : resultVariables) {
            if (varName != null) {
                this.objectVarNames.add(varName);
                continue;
            }
            throw new IllegalArgumentException(SELECT_WITH_EXPRESSIONS_NOT_SUPPORTED_IN_MAGIC_PROPERTIES);
        }
        int selectStart = this.queryString.indexOf("SELECT ");
        int eol = this.queryString.indexOf(10, selectStart);
        StringBuffer sb = new StringBuffer(this.queryString.substring(0, eol));
        for (Argument arg : functionCls.getArguments(true)) {
            sb.append(" ?");
            sb.append(arg.getVarName());
        }
        sb.append(this.queryString.substring(eol));
        try {
            this.arqQuery = ARQFactory.get().createQuery(sb.toString());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Function definition does not contain a valid body. Internally used query string:\n" + sb, ex);
        }
    }

    public PropertyFunction create(String arg0) {
        return this;
    }

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext context) {
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        ExprList subjectExprList = argSubject.asExprList(argSubject);
        ExprList objectExprList = argObject.asExprList(argObject);
        QueryIterConcat existingValues = null;
        MagicPropertyPolicy.Policy policy = MagicPropertyPolicy.Policy.QUERY_RESULTS_ONLY;
        if (objectExprList.size() == 1 && subjectExprList.size() == 1) {
            Expr subject = subjectExprList.get(0);
            Expr object = objectExprList.get(0);
            if (subject.isVariable() || object.isVariable()) {
                Node n;
                Node matchSubject = null;
                if (subject.isConstant() && ((n = subject.getConstant().asNode()).isURI() || n.isBlank())) {
                    matchSubject = n;
                }
                Node matchObject = null;
                if (object.isConstant()) {
                    matchObject = object.getConstant().asNode();
                }
                Graph queryGraph = context.getActiveGraph();
                policy = MagicPropertyPolicy.get().getPolicy(predicate.getURI(), queryGraph, matchSubject, matchObject);
                if (policy != MagicPropertyPolicy.Policy.QUERY_RESULTS_ONLY) {
                    ExtendedIterator it = queryGraph.find(matchSubject, predicate, matchObject);
                    while (it.hasNext()) {
                        Triple triple = (Triple)it.next();
                        BindingHashMap map = new BindingHashMap(binding);
                        if (subject.isVariable()) {
                            map.add(subject.asVar(), triple.getSubject());
                        }
                        if (object.isVariable()) {
                            map.add(object.asVar(), triple.getObject());
                        }
                        if (existingValues == null) {
                            existingValues = new QueryIterConcat(context);
                        }
                        QueryIterator nested = IterLib.result((Binding)map, (ExecutionContext)context);
                        existingValues.add(nested);
                    }
                }
            }
        }
        if (policy != MagicPropertyPolicy.Policy.TRIPLES_ONLY) {
            NodeValue x;
            Var var;
            int i;
            Graph activeGraph = context.getActiveGraph();
            if (activeGraph == null) {
                activeGraph = JenaUtil.createDefaultGraph();
            }
            Model model = ModelFactory.createModelForGraph((Graph)activeGraph);
            Node t = binding.get(Var.alloc((String)"this"));
            QuerySolutionMap bindings = new QuerySolutionMap();
            if (t != null) {
                bindings.add("this", model.asRDFNode(t));
            }
            HashMap<String, Var> vars = new HashMap<String, Var>();
            for (i = 0; i < this.objectVarNames.size() && i < objectExprList.size(); ++i) {
                Expr expr = objectExprList.get(i);
                String objectVarName = this.objectVarNames.get(i);
                if (expr.isVariable() && !binding.contains(expr.asVar())) {
                    var = expr.asVar();
                    vars.put(objectVarName, var);
                    continue;
                }
                x = expr.eval(binding, (FunctionEnv)context);
                if (x == null) continue;
                bindings.add(objectVarName, model.asRDFNode(x.asNode()));
            }
            for (i = 0; i < subjectExprList.size(); ++i) {
                String subjectVarName = "arg" + (i + 1);
                Expr expr = subjectExprList.get(i);
                if (expr.isVariable() && !binding.contains(expr.asVar())) {
                    var = expr.asVar();
                    vars.put(subjectVarName, var);
                    continue;
                }
                x = expr.eval(binding, (FunctionEnv)context);
                if (x == null) continue;
                bindings.add(subjectVarName, model.asRDFNode(x.asNode()));
            }
            DatasetWithDifferentDefaultModel newDataset = new DatasetWithDifferentDefaultModel(model, DatasetImpl.wrap((DatasetGraph)context.getDataset()));
            QueryExecution qexec = ARQFactory.get().createQueryExecution(this.arqQuery, newDataset, (QuerySolution)bindings);
            ResultSet rs = qexec.execSelect();
            PFunctionQueryIterator it = new PFunctionQueryIterator(rs, qexec, vars, binding);
            if (existingValues != null) {
                existingValues.add((QueryIterator)it);
                return existingValues;
            }
            return it;
        }
        if (existingValues != null) {
            return existingValues;
        }
        return IterLib.result((Binding)binding, (ExecutionContext)context);
    }
}

