/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.topbraid.spin.arq.DelegatingDataset;
import org.topbraid.spin.util.JenaUtil;

public class FromDataset
extends DelegatingDataset {
    private Set<String> defaultGraphs;
    private Model defaultModel;
    private Set<String> namedGraphs;

    public FromDataset(Dataset delegate, Query query) {
        super(delegate);
        this.defaultGraphs = new HashSet<String>(query.getGraphURIs());
        this.namedGraphs = new HashSet<String>(query.getNamedGraphURIs());
    }

    @Override
    public boolean containsNamedModel(String uri) {
        if (this.namedGraphs.isEmpty()) {
            return true;
        }
        return this.namedGraphs.contains(uri);
    }

    @Override
    public Model getDefaultModel() {
        if (this.defaultGraphs.isEmpty()) {
            return super.getDefaultModel();
        }
        if (this.defaultModel == null) {
            if (this.defaultGraphs.size() == 1) {
                String defaultGraphURI = this.defaultGraphs.iterator().next();
                this.defaultModel = this.getNamedModel(defaultGraphURI);
            } else {
                MultiUnion multiUnion = JenaUtil.createMultiUnion();
                for (String baseURI : this.defaultGraphs) {
                    Model model = this.getNamedModel(baseURI);
                    multiUnion.addGraph(model.getGraph());
                }
                this.defaultModel = ModelFactory.createModelForGraph((Graph)multiUnion);
            }
        }
        return this.defaultModel;
    }

    @Override
    public Iterator<String> listNames() {
        if (this.namedGraphs.isEmpty()) {
            return super.listNames();
        }
        return this.namedGraphs.iterator();
    }
}

